/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class ModularGuiContainer<T extends Container>
extends ContainerScreen<T>
implements IModularGui<ModularGuiContainer> {
    protected GuiElementManager manager = new GuiElementManager(this);
    protected int zLevel = 0;
    protected T container;
    protected boolean itemTooltipsEnabled = true;
    public boolean enableDefaultBackground = true;
    private boolean experimentalSlotOcclusion = false;
    @Deprecated
    protected boolean dumbGui = false;

    public ModularGuiContainer(T container, PlayerInventory inv, ITextComponent titleIn) {
        super(container, inv, titleIn);
        this.container = container;
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.field_230707_j_ = this.field_230706_i_.func_175599_af();
        this.field_230712_o_ = this.field_230706_i_.field_71466_p;
        this.field_230708_k_ = this.field_230706_i_.func_228018_at_().func_198107_o();
        this.field_230709_l_ = this.field_230706_i_.func_228018_at_().func_198087_p();
        this.manager.setWorldAndResolution(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    public final void func_231160_c_() {
        super.func_231160_c_();
        this.manager.onGuiInit(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.reloadGui();
    }

    public void reloadGui() {
        this.manager.reloadElements();
    }

    @Override
    public ModularGuiContainer getScreen() {
        return this;
    }

    @Override
    public int xSize() {
        return this.field_146999_f;
    }

    @Override
    public int ySize() {
        return this.field_147000_g;
    }

    @Override
    public void setUISize(int xSize, int ySize) {
        this.field_146999_f = xSize;
        this.field_147000_g = ySize;
    }

    @Override
    public int guiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int guiTop() {
        return this.field_147009_r;
    }

    @Override
    public GuiElementManager getManager() {
        return this.manager;
    }

    @Override
    public void setZLevel(int zLevel) {
        this.zLevel = zLevel;
    }

    @Override
    public int getZLevel() {
        return this.zLevel;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.dumbGui && this.manager.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (!this.dumbGui && this.manager.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.manager.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        if (!this.dumbGui && this.manager.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, clickedMouseButton, dragX, dragY);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (!this.dumbGui && this.manager.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        boolean handled = this.func_195363_d(keyCode, scanCode);
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 0, ClickType.CLONE);
                handled = true;
            } else if (this.field_230706_i_.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, ModularGuiContainer.func_231172_r_() ? 1 : 0, ClickType.THROW);
                handled = true;
            }
        } else if (this.field_230706_i_.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
            handled = true;
        }
        return handled;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (!this.dumbGui && this.manager.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char charTyped, int charCode) {
        if (!this.dumbGui && this.manager.charTyped(charTyped, charCode)) {
            return true;
        }
        return super.func_231042_a_(charTyped, charCode);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        if (!this.dumbGui && this.manager.mouseScrolled(mouseX, mouseY, scrollAmount)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, scrollAmount);
    }

    public double getMouseX() {
        return this.field_230706_i_.field_71417_B.func_198024_e() * (double)this.field_230706_i_.func_228018_at_().func_198107_o() / (double)this.field_230706_i_.func_228018_at_().func_198105_m();
    }

    public double getMouseY() {
        return this.field_230706_i_.field_71417_B.func_198026_f() * (double)this.field_230706_i_.func_228018_at_().func_198087_p() / (double)this.field_230706_i_.func_228018_at_().func_198083_n();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.renderBackgroundLayer(mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.dumbGui) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            return;
        }
        if (this.enableDefaultBackground) {
            this.func_230446_a_(matrixStack);
        }
        this.renderSuperScreen(matrixStack, mouseX, mouseY, partialTicks);
        this.renderOverlayLayer(mouseX, mouseY, partialTicks);
        if (this.itemTooltipsEnabled) {
            RenderSystem.translated((double)0.0, (double)0.0, (double)400.0);
            this.func_230459_a_(matrixStack, mouseX, mouseY);
            RenderSystem.translated((double)0.0, (double)0.0, (double)-400.0);
        }
    }

    public void renderBackgroundLayer(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderElements(this.field_230706_i_, mouseX, mouseY, partialTicks);
    }

    public void renderOverlayLayer(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderOverlayLayer(this.field_230706_i_, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.manager.onUpdate();
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        this.manager.setWorldAndResolution(mc, width, height);
    }

    public void renderSuperScreen(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ItemStack itemstack;
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        this.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawBackground((ContainerScreen)this, matrixStack, mouseX, mouseY));
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)left, (float)top, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        this.field_147006_u = null;
        int k = 240;
        int l = 240;
        RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < ((Container)this.container).field_75151_b.size(); ++i1) {
            boolean occluded;
            Slot slot = (Slot)((Container)this.container).field_75151_b.get(i1);
            if (slot.func_111238_b()) {
                this.drawSlot(matrixStack, slot);
            }
            if ((occluded = this.manager.isAreaUnderElement(slot.field_75223_e + this.guiLeft(), slot.field_75221_f + this.guiTop(), 16, 16, 100)) && !this.experimentalSlotOcclusion) continue;
            if (!occluded && this.func_195362_a(slot, mouseX, mouseY) && slot.func_111238_b()) {
                this.field_147006_u = slot;
                RenderSystem.disableDepthTest();
                int j1 = slot.field_75223_e;
                int k1 = slot.field_75221_f;
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int slotColor = this.getSlotColor(i1);
                this.func_238468_a_(matrixStack, j1, k1, j1 + 16, k1 + 16, slotColor, slotColor);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
            this.drawSlotOverlay(slot, occluded);
        }
        this.func_230451_b_(matrixStack, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((ContainerScreen)this, matrixStack, mouseX, mouseY));
        PlayerInventory playerinventory = this.field_230706_i_.field_71439_g.field_71071_by;
        ItemStack itemStack = itemstack = this.field_147012_x.func_190926_b() ? playerinventory.func_70445_o() : this.field_147012_x;
        if (!itemstack.func_190926_b()) {
            int j2 = 8;
            int k2 = this.field_147012_x.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.field_147012_x.func_190926_b() && this.field_147004_w) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.field_146996_I);
                if (itemstack.func_190926_b()) {
                    s = "" + TextFormatting.YELLOW + "0";
                }
            }
            this.func_146982_a(itemstack, mouseX - left - 8, mouseY - top - k2, s);
        }
        if (!this.field_146991_C.func_190926_b()) {
            float f = (float)(Util.func_211177_b() - this.field_146990_B) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.field_146991_C = ItemStack.field_190927_a;
            }
            int l2 = this.field_146989_A.field_75223_e - this.field_147011_y;
            int i3 = this.field_146989_A.field_75221_f - this.field_147010_z;
            int l1 = this.field_147011_y + (int)((float)l2 * f);
            int i2 = this.field_147010_z + (int)((float)i3 * f);
            this.func_146982_a(this.field_146991_C, l1, i2, null);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
    }

    private void drawSlot(MatrixStack matrixStack, Slot slotIn) {
        Pair pair;
        int yPos = slotIn.field_75221_f;
        int xPos = slotIn.field_75223_e;
        boolean occluded = this.manager.isAreaUnderElement(xPos + this.guiLeft(), yPos + this.guiTop(), 16, 16, 100);
        if (occluded && !this.experimentalSlotOcclusion) {
            return;
        }
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack itemstack1 = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slotIn) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.container.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a((Set)this.field_147008_s, (int)this.field_146987_F, (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.field_147008_s.remove(slotIn);
                this.func_146980_g();
            }
        }
        this.func_230926_e_(100);
        this.field_230707_j_.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (pair = slotIn.func_225517_c_()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_((ResourceLocation)pair.getFirst()).apply(pair.getSecond());
            this.field_230706_i_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            ModularGuiContainer.func_238470_a_((MatrixStack)matrixStack, (int)xPos, (int)yPos, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                ModularGuiContainer.func_238467_a_((MatrixStack)matrixStack, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            }
            RenderSystem.enableDepthTest();
            this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, itemstack, xPos, yPos);
            if (!occluded) {
                this.field_230707_j_.func_180453_a(this.field_230712_o_, itemstack, xPos, yPos, s);
            }
        }
        this.field_230707_j_.field_77023_b = 0.0f;
        this.func_230926_e_(0);
    }

    protected void drawSlotOverlay(Slot slot, boolean occluded) {
    }

    public void setExperimentalSlotOcclusion(boolean experimentalSlotOcclusion) {
        this.experimentalSlotOcclusion = experimentalSlotOcclusion;
    }

    public int getGuiLeft() {
        return this.guiLeft();
    }

    public int getGuiTop() {
        return this.guiTop();
    }

    public int getXSize() {
        return this.xSize();
    }

    public int getYSize() {
        return this.ySize();
    }
}

