/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.capability;

import com.brandon3055.brandonscore.api.power.IOPStorage;

public class OPIOControl
implements IOPStorage {
    protected boolean allowExtract = true;
    protected boolean allowReceive = true;
    private IOPStorage wrapped;

    public OPIOControl(IOPStorage wrapped) {
        this.wrapped = wrapped;
    }

    public OPIOControl setIOMode(boolean allowExtract, boolean allowReceive) {
        this.allowExtract = allowExtract;
        this.allowReceive = allowReceive;
        return this;
    }

    public OPIOControl setExtractOnly() {
        return this.setIOMode(true, false);
    }

    public OPIOControl setReceiveOnly() {
        return this.setIOMode(false, true);
    }

    public OPIOControl setIOMode(boolean inputOutput) {
        return this.setIOMode(!inputOutput, inputOutput);
    }

    @Override
    public boolean canExtract() {
        return this.allowExtract && this.wrapped.canExtract();
    }

    @Override
    public boolean canReceive() {
        return this.allowReceive && this.wrapped.canReceive();
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.wrapped.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.wrapped.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored() {
        return this.wrapped.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.wrapped.getMaxEnergyStored();
    }

    @Override
    public long receiveOP(long maxReceive, boolean simulate) {
        return this.wrapped.receiveOP(maxReceive, simulate);
    }

    @Override
    public long extractOP(long maxExtract, boolean simulate) {
        return this.wrapped.extractOP(maxExtract, simulate);
    }

    @Override
    public long getOPStored() {
        return this.wrapped.getOPStored();
    }

    @Override
    public long getMaxOPStored() {
        return this.wrapped.getMaxOPStored();
    }
}

