/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.hud;

import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IHudDisplay {
    @OnlyIn(value=Dist.CLIENT)
    default public double computeHudWidth(Minecraft mc, List<ITextComponent> displayList) {
        double maxWidth = 0.0;
        for (ITextComponent text : displayList) {
            maxWidth = Math.max(maxWidth, (double)mc.field_71466_p.func_238414_a_((ITextProperties)text));
        }
        return maxWidth + 8.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public double computeHudHeight(Minecraft mc, List<ITextComponent> displayList) {
        return displayList.size() * 10 + 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHudBackground(IRenderTypeBuffer getter, MatrixStack mStack, double width, double height, List<ITextComponent> displayList) {
        GuiHelper.drawHoverRect(getter, mStack, 0.0, 0.0, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHudContent(FontRenderer font, MatrixStack mStack, double width, double height, List<ITextComponent> displayList) {
        mStack.func_227861_a_(4.0, 4.0, 0.0);
        for (ITextComponent text : displayList) {
            font.func_243246_a(mStack, text, 0.0f, 0.0f, 0xFFFFFF);
            mStack.func_227861_a_(0.0, 10.0, 0.0);
        }
    }
}

