/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ChangeRecipePriorityMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int recipeLocation;
    private boolean up;
    private String id;
    private boolean fullMove;

    public ChangeRecipePriorityMessage() {
    }

    public ChangeRecipePriorityMessage(@NotNull IBuildingView building, int location, boolean up, String id, boolean fullMove) {
        super(building);
        this.recipeLocation = location;
        this.up = up;
        this.id = id;
        this.fullMove = fullMove;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.recipeLocation = buf.readInt();
        this.up = buf.readBoolean();
        this.id = buf.func_150789_c(Short.MAX_VALUE);
        this.fullMove = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.recipeLocation);
        buf.writeBoolean(this.up);
        buf.func_180714_a(this.id);
        buf.writeBoolean(this.fullMove);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        AbstractCraftingBuildingModule module = building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        if (this.up) {
            module.switchOrder(this.recipeLocation, this.recipeLocation - 1, this.fullMove);
        } else {
            module.switchOrder(this.recipeLocation, this.recipeLocation + 1, this.fullMove);
        }
    }
}

