/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildToolPlaceMessage
implements IMessage {
    private BlockState state;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;
    public BlockPos builder = BlockPos.field_177992_a;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, BlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.state = state;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.structureName = buf.func_150789_c(Short.MAX_VALUE);
        this.workOrderName = buf.func_150789_c(Short.MAX_VALUE);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.state = Block.func_196257_b((int)buf.readInt());
        this.builder = buf.func_179259_c();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.structureName);
        buf.func_180714_a(this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeInt(Block.func_196246_j((BlockState)this.state));
        buf.func_179255_a(this.builder);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayerEntity player = ctxIn.getSender();
        StructureName sn = new StructureName(this.structureName);
        if (!Structures.hasMD5((StructureName)sn)) {
            MessageUtils.format((ITextComponent)new StringTextComponent("Can not build " + this.workOrderName + ": schematic missing!")).sendTo(new PlayerEntity[]{player});
            return;
        }
        if (this.isHut) {
            BuildToolPlaceMessage.handleHut(CompatibilityUtils.getWorldFromEntity((Entity)player), (PlayerEntity)player, sn, this.rotation, this.pos, this.mirror, this.state);
        } else {
            BuildToolPlaceMessage.handleDecoration(CompatibilityUtils.getWorldFromEntity((Entity)player), (PlayerEntity)player, sn, this.workOrderName, this.rotation, this.pos, this.mirror, this.builder);
        }
    }

    private static void handleHut(@NotNull World world, @NotNull PlayerEntity player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockState state) {
        Block blockAtPos = world.func_180495_p(buildPos).func_177230_c();
        if (blockAtPos instanceof IBuilderUndestroyable || ModTags.indestructible.func_230235_a_((Object)blockAtPos)) {
            MessageUtils.format("com.minecolonies.coremod.buildtool.indestructible", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, buildPos);
            return;
        }
        Block block = state.func_177230_c();
        ItemStack tempStack = new ItemStack((IItemProvider)block, 1);
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, s, false, false));
        if (slot < 0) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70301_a(slot);
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, buildPos);
        if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) || block instanceof BlockHutTownHall && IColonyManager.getInstance().isFarEnoughFromColonies(world, buildPos))) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p();
        if (tempColony != null && compound != null && compound.func_74764_b("colony") && tempColony.getID() != compound.func_74762_e("colony")) {
            MessageUtils.format("com.minecolonies.coremod.gui.buildtool.wrongcolony", compound.func_74762_e("colony")).sendTo(player);
            return;
        }
        if (block != null && player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)block))) {
            if (EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
                if (tempColony != null) {
                    AdvancementUtils.TriggerAdvancementPlayersForColony(tempColony, playerMP -> AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayerEntity)playerMP, sn));
                } else {
                    AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayerEntity)player, sn);
                }
                world.func_175655_b(buildPos, true);
                world.func_175656_a(buildPos, state);
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (LivingEntity)player, null, mirror, sn.getStyle());
                boolean complete = false;
                int level = 0;
                if (compound != null) {
                    if (compound.func_150296_c().contains("otherLevel")) {
                        level = compound.func_74762_e("otherLevel");
                    }
                    if (compound.func_150296_c().contains("isPasteable")) {
                        String schematic = sn.toString();
                        schematic = schematic.substring(0, schematic.length() - 1);
                        schematic = schematic + level;
                        CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.field_70170_p, schematic, buildPos, BlockPosUtil.getRotationFromRotations(rotation), mirror ? Mirror.FRONT_BACK : Mirror.NONE, true, (ServerPlayerEntity)player);
                        complete = true;
                    }
                }
                InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack, 1);
                BuildToolPlaceMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror, level, complete);
            }
        } else {
            MessageUtils.format("com.minecolonies.coremod.gui.buildtool.nohutininventory", new Object[0]).sendTo(player);
        }
    }

    private static void handleDecoration(@NotNull World world, @NotNull PlayerEntity player, StructureName sn, String workOrderName, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockPos builder) {
        @Nullable IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            String schem = sn.toString();
            String woName = workOrderName;
            if (!schem.contains("cache")) {
                if (schem.matches("^.*[a-zA-Z_-]\\d$")) {
                    schem = schem.replaceAll("\\d$", "");
                    schem = schem + '1';
                }
                if (woName.matches("^.*[a-zA-Z_-]\\d$")) {
                    woName = woName.replaceAll("\\d$", "");
                    woName = woName + '1';
                }
            }
            WorkOrderDecoration woDeco = WorkOrderDecoration.create(WorkOrderType.BUILD, schem, WordUtils.capitalizeFully((String)woName), buildPos, rotation, mirror, 0);
            if (!builder.equals((Object)BlockPos.field_177992_a)) {
                woDeco.setClaimedBy(builder);
            }
            colony.getWorkManager().addWorkOrder(woDeco, false);
        } else {
            SoundUtils.playErrorSound(player, player.func_233580_cy_());
            Log.getLogger().error("handleDecoration: Could not build " + sn, (Throwable)new Exception());
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull PlayerEntity player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, int level, boolean complete) {
        @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, buildPos);
        if (building == null) {
            if (!sn.getHutName().equals("townhall")) {
                SoundUtils.playErrorSound(player, player.func_233580_cy_());
                Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
            }
        } else {
            SoundUtils.playSuccessSound(player, player.func_233580_cy_());
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.func_200200_C_().getString());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            building.setStyle(sn.getStyle());
            building.setBuildingLevel(level);
            if (level > 0) {
                building.setDeconstructed();
            }
            if (!(building instanceof IRSComponent)) {
                ConstructionTapeHelper.placeConstructionTape(building.getCorners(), world);
            }
            building.setIsMirrored(mirror);
            if (complete) {
                building.onUpgradeComplete(building.getBuildingLevel());
            }
        }
    }
}

