/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPathReachedMessage
implements IMessage {
    public Set<BlockPos> reached = new HashSet<BlockPos>();

    public SyncPathReachedMessage() {
    }

    public SyncPathReachedMessage(Set<BlockPos> reached) {
        this.reached = reached;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.reached.size());
        for (BlockPos node : this.reached) {
            buf.func_179255_a(node);
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.reached.add(buf.func_179259_c());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        for (Node node : Pathfinding.lastDebugNodesPath) {
            if (!this.reached.contains(node.pos)) continue;
            node.setReachedByWorker(true);
        }
    }
}

