/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structurize.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HighlightManager {
    @Nullable
    public static final Map<String, List<TimedBoxRenderData>> HIGHLIGHT_MAP = new HashMap<String, List<TimedBoxRenderData>>();
    public static final RenderTypeBuffers renderBuffers = new RenderTypeBuffers();
    private static final IRenderTypeBuffer.Impl renderBuffer = renderBuffers.func_228487_b_();
    private static final Supplier<IVertexBuilder> linesWithoutCullAndDepth = () -> renderBuffer.getBuffer(RenderUtils.LINES_GLINT);

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        if (!HIGHLIGHT_MAP.isEmpty()) {
            long worldTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            Iterator<List<TimedBoxRenderData>> categoryIterator = HIGHLIGHT_MAP.values().iterator();
            while (categoryIterator.hasNext()) {
                List<TimedBoxRenderData> boxes = categoryIterator.next();
                Iterator<TimedBoxRenderData> boxListIterator = boxes.iterator();
                while (boxListIterator.hasNext()) {
                    TimedBoxRenderData boxRenderData = boxListIterator.next();
                    if (boxRenderData.removalTimePoint <= worldTime) {
                        boxListIterator.remove();
                        continue;
                    }
                    RenderUtils.renderBox((BlockPos)boxRenderData.pos, (BlockPos)boxRenderData.pos, (float)boxRenderData.getRed(), (float)boxRenderData.getGreen(), (float)boxRenderData.getBlue(), (float)1.0f, (double)0.002, (MatrixStack)event.getMatrixStack(), (IVertexBuilder)linesWithoutCullAndDepth.get());
                    if (boxRenderData.text.isEmpty()) continue;
                    IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                    RenderUtils.renderDebugText((BlockPos)boxRenderData.pos, (List)boxRenderData.text, (MatrixStack)event.getMatrixStack(), (boolean)true, (int)3, (IRenderTypeBuffer)buffer);
                    RenderSystem.disableDepthTest();
                    buffer.func_228461_a_();
                    RenderSystem.enableDepthTest();
                }
                if (!boxes.isEmpty()) continue;
                categoryIterator.remove();
            }
        }
        renderBuffer.func_228461_a_();
    }

    public static void addRenderBox(String category, TimedBoxRenderData data) {
        HIGHLIGHT_MAP.computeIfAbsent(category, k -> new ArrayList()).add(data);
    }

    public static void clearCategory(String category) {
        HIGHLIGHT_MAP.remove(category);
    }

    public static class TimedBoxRenderData {
        private List<String> text = new ArrayList<String>();
        private BlockPos pos = BlockPos.field_177992_a;
        private long removalTimePoint = 0L;
        private int hexColor = 0xFFFFFF;

        public TimedBoxRenderData addText(String text) {
            this.text.add(text);
            return this;
        }

        public TimedBoxRenderData setRemovalTimePoint(long removalTimePoint) {
            this.removalTimePoint = removalTimePoint;
            return this;
        }

        public TimedBoxRenderData setPos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        public TimedBoxRenderData setColor(int hexColor) {
            this.hexColor = hexColor;
            return this;
        }

        private float getRed() {
            return (float)(this.hexColor >> 16 & 0xFF) / 255.0f;
        }

        private float getGreen() {
            return (float)(this.hexColor >> 8 & 0xFF) / 255.0f;
        }

        private float getBlue() {
            return (float)(this.hexColor & 0xFF) / 255.0f;
        }
    }
}

