/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEntitySpawnEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IEventStructureManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.managers.EventStructureManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EventManager
implements IEventManager {
    private static final String TAG_EVENT_ID = "event_currentID";
    private static final String TAG_EVENT_MANAGER = "event_manager";
    private static final String TAG_EVENT_LIST = "events_list";
    private int currentEventID = 1;
    private final IColony colony;
    private final Map<Integer, IColonyEvent> events = new HashMap<Integer, IColonyEvent>();
    private final EventStructureManager structureManager;

    public EventManager(IColony colony) {
        this.colony = colony;
        this.structureManager = new EventStructureManager(this, colony);
    }

    @Override
    public void addEvent(IColonyEvent colonyEvent) {
        if (colonyEvent.getID() == 0) {
            Log.getLogger().warn("missing ID for event:" + colonyEvent.getEventTypeID().func_110623_a());
            return;
        }
        this.events.put(colonyEvent.getID(), colonyEvent);
        this.colony.markDirty();
    }

    @Override
    public int getAndTakeNextEventID() {
        if (this.currentEventID > 2147483547) {
            this.currentEventID = 1;
        }
        ++this.currentEventID;
        this.colony.markDirty();
        return this.currentEventID - 1;
    }

    @Override
    public void registerEntity(@NotNull Entity entity, int eventID) {
        IColonyEvent event = this.events.get(eventID);
        if (!(event instanceof IColonyEntitySpawnEvent)) {
            entity.func_70106_y();
            return;
        }
        ((IColonyEntitySpawnEvent)event).registerEntity(entity);
    }

    @Override
    public void unregisterEntity(@NotNull Entity entity, int eventID) {
        IColonyEvent event = this.events.get(eventID);
        if (event instanceof IColonyEntitySpawnEvent) {
            ((IColonyEntitySpawnEvent)event).unregisterEntity(entity);
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity, int eventID) {
        IColonyEvent event = this.events.get(eventID);
        if (event instanceof IColonyEntitySpawnEvent) {
            ((IColonyEntitySpawnEvent)event).onEntityDeath(entity);
        }
    }

    @Override
    public void onTileEntityBreak(int eventID, TileEntity te) {
        IColonyEvent event = this.events.get(eventID);
        if (event != null) {
            event.onTileEntityBreak(te);
        }
    }

    @Override
    public void onNightFall() {
        for (IColonyEvent event : this.events.values()) {
            event.onNightFall();
        }
    }

    @Override
    public IColonyEvent getEventByID(int ID) {
        return this.events.get(ID);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        Iterator<IColonyEvent> iterator = this.events.values().iterator();
        while (iterator.hasNext()) {
            IColonyEvent event = iterator.next();
            if (event.getStatus() == EventStatus.DONE) {
                event.onFinish();
                this.structureManager.loadBackupForEvent(event.getID());
                colony.markDirty();
                iterator.remove();
                continue;
            }
            if (event.getStatus() == EventStatus.STARTING) {
                event.onStart();
                continue;
            }
            if (event.getStatus() == EventStatus.CANCELED) {
                colony.markDirty();
                iterator.remove();
                continue;
            }
            event.onUpdate();
        }
    }

    @Override
    public Map<Integer, IColonyEvent> getEvents() {
        return this.events;
    }

    @Override
    public void readFromNBT(@NotNull CompoundNBT compound) {
        if (compound.func_74764_b(TAG_EVENT_MANAGER)) {
            CompoundNBT eventManagerNBT = compound.func_74775_l(TAG_EVENT_MANAGER);
            ListNBT eventListNBT = eventManagerNBT.func_150295_c(TAG_EVENT_LIST, 10);
            for (INBT base : eventListNBT) {
                CompoundNBT tagCompound = (CompoundNBT)base;
                ResourceLocation eventTypeID = new ResourceLocation("minecolonies", tagCompound.func_74779_i("name"));
                ColonyEventTypeRegistryEntry registryEntry = (ColonyEventTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventRegistry().getValue(eventTypeID);
                if (registryEntry == null) {
                    Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.func_110623_a());
                    continue;
                }
                IColonyEvent colonyEvent = registryEntry.deserializeEvent(this.colony, tagCompound);
                this.events.put(colonyEvent.getID(), colonyEvent);
            }
            this.currentEventID = eventManagerNBT.func_74762_e(TAG_EVENT_ID);
            this.structureManager.readFromNBT(compound);
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundNBT compound) {
        CompoundNBT eventManagerNBT = new CompoundNBT();
        ListNBT eventListNBT = new ListNBT();
        for (IColonyEvent event : this.events.values()) {
            CompoundNBT eventNBT = (CompoundNBT)event.serializeNBT();
            eventNBT.func_74778_a("name", event.getEventTypeID().func_110623_a());
            eventListNBT.add((Object)eventNBT);
        }
        eventManagerNBT.func_74768_a(TAG_EVENT_ID, this.currentEventID);
        eventManagerNBT.func_218657_a(TAG_EVENT_LIST, (INBT)eventListNBT);
        compound.func_218657_a(TAG_EVENT_MANAGER, (INBT)eventManagerNBT);
        this.structureManager.writeToNBT(compound);
    }

    @Override
    public IEventStructureManager getStructureManager() {
        return this.structureManager;
    }
}

