/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.google.common.collect.Lists;
import com.minecolonies.api.inventory.container.ContainerField;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.FieldPlotResizeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WindowField
extends ContainerScreen<ContainerField> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/scarecrow.png");
    private static final int X_OFFSET = 8;
    private static final int Y_OFFSET = 6;
    private static final int TEXT_COLOR = 0x404040;
    private static final int BUTTON_SIDE_LENGTH = 24;
    private final AbstractScarecrowTileEntity tileEntity;
    private final int[] radii = new int[4];

    public WindowField(ContainerField container, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super((Container)container, playerInventory, iTextComponent);
        this.tileEntity = container.getTileEntity();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int centerX = this.field_147003_i + this.field_146999_f / 2 + 1;
        int centerY = this.field_147009_r + this.field_147000_g / 2;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int xFromPolar = (int)Math.sin(Math.PI * (double)(4 - dir.func_176736_b()) / 2.0) * 24;
            int yFromPolar = (int)Math.cos(Math.PI * (double)(4 - dir.func_176736_b()) / 2.0) * 24;
            this.radii[dir.func_176736_b()] = this.tileEntity.getRadius(dir);
            DirectionalButton db = new DirectionalButton(centerX + xFromPolar - 12, centerY - 40 + yFromPolar - 12, 24, 24, (ITextComponent)new StringTextComponent(String.valueOf(this.radii[dir.func_176736_b()])), dir);
            this.func_230480_a_((Widget)db);
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack stack, int mouseX, int mouseY) {
        if (!this.tileEntity.getOwner().isEmpty()) {
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.field.worker", new Object[]{this.tileEntity.getOwner()}), 8.0f, -12.0f, 0xFFFFFF);
        }
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("block.minecolonies.blockhutfield"), 8.0f, 6.0f, 0x404040);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(stack, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    protected void func_230450_a_(@NotNull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int marginHorizontal = (this.field_230708_k_ - this.field_146999_f) / 2;
        int marginVertical = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, marginHorizontal, marginVertical, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_230430_a_(@NotNull MatrixStack stack, int x, int y, float z) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, x, y, z);
        this.func_230459_a_(stack, x, y);
    }

    protected class DirectionalButton
    extends Button {
        public Direction direction;
        public int textureX;
        public int textureY;
        public int columns;

        public DirectionalButton(int x, int y, int width, int height, ITextComponent text, Direction direction) {
            super(x, y, width, height, text, button -> {});
            this.textureX = 176;
            this.textureY = 0;
            this.columns = 2;
            this.direction = direction;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.func_230992_c_(mouseX, mouseY)) {
                int index = this.direction.func_176736_b();
                int delta = this.func_230987_a_(button) ? 1 : -1;
                ((WindowField)WindowField.this).radii[index] = (WindowField.this.radii[index] + delta) % (ScarecrowTileEntity.getMaxRange() + 1);
                if (WindowField.this.radii[index] < 0) {
                    ((WindowField)WindowField.this).radii[index] = ScarecrowTileEntity.getMaxRange();
                }
                this.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(WindowField.this.radii[index])));
                Network.getNetwork().sendToServer(new FieldPlotResizeMessage(WindowField.this.radii[index], this.direction, WindowField.this.tileEntity.func_174877_v()));
                return true;
            }
            return false;
        }

        public int getTextureXOffset() {
            return this.textureX + 24 * Math.floorDiv(this.direction.func_176736_b(), this.columns);
        }

        public int getTextureYOffset() {
            return this.textureY + 72 * (this.direction.func_176736_b() % this.columns);
        }

        public int getTextOffset(Direction.Axis axis) {
            switch (this.direction) {
                case NORTH: {
                    return axis == Direction.Axis.X ? 0 : 2;
                }
                case EAST: {
                    return axis == Direction.Axis.X ? -2 : 0;
                }
                case SOUTH: {
                    return axis == Direction.Axis.X ? 0 : -2;
                }
                case WEST: {
                    return axis == Direction.Axis.X ? 2 : 0;
                }
            }
            return 0;
        }

        public void func_230431_b_(@NotNull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            int i = this.func_230989_a_(this.func_230449_g_());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_238474_b_(stack, this.field_230690_l_, this.field_230691_m_, this.getTextureXOffset(), this.getTextureYOffset() + i * 24, this.field_230688_j_, this.field_230689_k_);
            this.func_230441_a_(stack, minecraft, mouseX, mouseY);
            int j = this.getFGColor();
            DirectionalButton.func_238472_a_((MatrixStack)stack, (FontRenderer)fontrenderer, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2 + this.getTextOffset(Direction.Axis.X)), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2 + this.getTextOffset(Direction.Axis.Y)), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
        }

        public void func_230443_a_(@NotNull MatrixStack stack, int mouseX, int mouseY) {
            if (!WindowField.this.field_213127_e.func_70445_o().func_190926_b()) {
                return;
            }
            ArrayList lines = Lists.newArrayList((Object[])new ITextProperties[]{new TranslationTextComponent("com.minecolonies.coremod.gui.field." + this.direction.func_176610_l()), new TranslationTextComponent(this.getDirectionalTranslationKey()).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GRAY))});
            WindowField.this.func_238654_b_(stack, LanguageMap.func_74808_a().func_244260_a((List)lines), mouseX, mouseY);
        }

        public String getDirectionalTranslationKey() {
            Direction[] looks = Direction.func_196054_a((Entity)((WindowField)WindowField.this).field_213127_e.field_70458_d);
            Direction facing = looks[0].func_176740_k() == Direction.Axis.Y ? looks[1] : looks[0];
            switch (facing.func_176734_d().func_176736_b() - this.direction.func_176736_b()) {
                case -3: 
                case 1: {
                    return "com.minecolonies.coremod.gui.field.to_right";
                }
                case -2: 
                case 2: {
                    return "com.minecolonies.coremod.gui.field.opposite";
                }
                case -1: 
                case 3: {
                    return "com.minecolonies.coremod.gui.field.to_left";
                }
            }
            return "com.minecolonies.coremod.gui.field.near";
        }
    }
}

