/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.citizen;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.citizen.AbstractWindowCitizen;
import com.minecolonies.coremod.client.gui.citizen.CitizenWindowUtils;
import com.minecolonies.coremod.network.messages.server.colony.citizen.AdjustSkillCitizenMessage;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MainWindowCitizen
extends AbstractWindowCitizen {
    private final ICitizenDataView citizen;
    private int tick = 0;

    public MainWindowCitizen(ICitizenDataView citizen) {
        super(citizen, "minecolonies:gui/citizen/main.xml");
        this.citizen = citizen;
        Image statusIcon = (Image)this.findPaneOfTypeByID("statusicon", Image.class);
        if (citizen.getVisibleStatus() == null) {
            statusIcon.setVisible(false);
        } else {
            statusIcon.setImage(citizen.getVisibleStatus().getIcon());
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((IFormattableTextComponent)new TranslationTextComponent(citizen.getVisibleStatus().getTranslationKey()))).hoverPane((Pane)statusIcon).build();
        }
    }

    public ICitizenDataView getCitizen() {
        return this.citizen;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick++ == 20) {
            this.tick = 0;
            CitizenWindowUtils.createSkillContent(this.citizen, this);
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ((Text)this.findPaneOfTypeByID("name", Text.class)).setText(this.citizen.getName());
        CitizenWindowUtils.createHealthBar(this.citizen, (View)this.findPaneOfTypeByID("healthBar", View.class));
        CitizenWindowUtils.createSaturationBar(this.citizen, (View)this);
        CitizenWindowUtils.createHappinessBar(this.citizen, this);
        CitizenWindowUtils.createSkillContent(this.citizen, this);
        if (this.citizen.isFemale()) {
            ((Image)this.findPaneOfTypeByID("gender", Image.class)).setImage("minecolonies:textures/gui/citizen/colonist_wax_female_smaller.png");
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (button.getID().contains("plus_")) {
            String label = button.getID().replace("plus_", "");
            Skill skill = Skill.valueOf(StringUtils.capitalize((String)label));
            Network.getNetwork().sendToServer(new AdjustSkillCitizenMessage(this.colony, this.citizen, 1, skill));
        } else if (button.getID().contains("minus_")) {
            String label = button.getID().replace("minus_", "");
            Skill skill = Skill.valueOf(StringUtils.capitalize((String)label));
            Network.getNetwork().sendToServer(new AdjustSkillCitizenMessage(this.colony, this.citizen, -1, skill));
        }
    }
}

