/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowSelectRes
extends AbstractWindowSkeleton {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
    private final Predicate<ItemStack> test;
    private final BiConsumer<ItemStack, Integer> consumer;
    private String filter = "";
    private int tick;

    public WindowSelectRes(Window origin, IBuildingView building, Predicate<ItemStack> test, BiConsumer<ItemStack, Integer> consumer, boolean displayQty) {
        super("minecolonies:gui/windowselectres.xml", origin);
        this.registerButton(BUTTON_DONE, this::doneClicked);
        this.registerButton(BUTTON_CANCEL, this::cancelClicked);
        this.registerButton("select", this::selectClicked);
        ((TextField)this.findPaneOfTypeByID("qty", TextField.class)).setText("1");
        if (!displayQty) {
            ((TextField)this.findPaneOfTypeByID("qty", TextField.class)).hide();
            ((Text)this.findPaneOfTypeByID("qtylabel", Text.class)).hide();
        }
        ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(new ItemStack((IItemProvider)Items.field_190931_a));
        ((Text)this.findPaneOfTypeByID("resourceName", Text.class)).setText(new ItemStack((IItemProvider)Items.field_190931_a).func_200301_q());
        this.test = test;
        this.consumer = consumer;
        ((TextField)this.window.findPaneOfTypeByID(INPUT_NAME, TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    private void selectClicked(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemStack to = this.allItems.get(row);
        ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(to);
        ((Text)this.findPaneOfTypeByID("resourceName", Text.class)).setText(to.func_200301_q());
    }

    private void cancelClicked() {
        this.close();
    }

    private void doneClicked() {
        ItemStack to = ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).getItem();
        int qty = 1;
        try {
            qty = Integer.parseInt(((TextField)this.findPaneOfTypeByID("qty", TextField.class)).getText());
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Invalid input in Selection Window for Quantity, defaulting to 1!");
        }
        this.consumer.accept(to, qty);
        this.close();
    }

    public void onOpened() {
        this.updateResources();
    }

    private void updateResources() {
        this.allItems.clear();
        for (ItemStack stack : ItemStackUtils.allItemsPlusInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            if (!this.test.test(stack) || !this.filter.isEmpty() && !stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !stack.func_200301_q().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
            this.allItems.add(stack);
        }
        this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.func_200301_q().getString(), (CharSequence)this.filter)));
        this.updateResourceList();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.func_200301_q());
                resourceLabel.setColors(WHITE);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

