/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import com.stal111.valhelsia_structures.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.tileentity.JarTileEntity;
import com.stal111.valhelsia_structures.utils.ModTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.helper.VoxelShapeHelper;

public class JarBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty TREASURE = ModBlockStateProperties.TREASURE;
    public static final BooleanProperty ROTATED = ModBlockStateProperties.ROTATED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE = VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.func_208617_a((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), Block.func_208617_a((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)});

    public JarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)TREASURE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new JarTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof JarTileEntity)) {
            return ActionResultType.PASS;
        }
        JarTileEntity jarTileEntity = (JarTileEntity)tileEntity;
        if (!this.canBePotted(Block.func_149634_a((Item)stack.func_77973_b())) && jarTileEntity.hasPlant()) {
            ItemStack flowerStack = jarTileEntity.getPlant();
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, flowerStack);
            } else if (!player.func_191521_c(flowerStack)) {
                player.func_71019_a(flowerStack, false);
            }
            jarTileEntity.setPlant(ItemStack.field_190927_a);
        } else if (this.canBePotted(Block.func_149634_a((Item)stack.func_77973_b())) && !jarTileEntity.hasPlant()) {
            jarTileEntity.setPlant(stack.func_77946_l().func_77979_a(1));
            player.func_195066_a(Stats.field_188088_V);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else {
            return ActionResultType.PASS;
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    private boolean canBePotted(Block block) {
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        boolean flag = BlockTags.field_200032_i.func_230236_b_().contains(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block.getRegistryName().func_110624_b(), "potted_" + block.getRegistryName().func_110623_a())));
        return flag && !ModTags.Items.JAR_BLACKLISTED.func_230235_a_((Object)block.func_199767_j());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf((MathHelper.func_76128_c((double)((double)((180.0f + context.func_195990_h()) * 8.0f / 360.0f) + 0.5)) & 7) % 2 != 0));
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        JarTileEntity jarTileEntity;
        TileEntity tileentity;
        if (!state.func_203425_a(newState.func_177230_c()) && (tileentity = world.func_175625_s(pos)) instanceof JarTileEntity && (jarTileEntity = (JarTileEntity)tileentity).hasPlant()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)jarTileEntity.getPlant());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TREASURE, ROTATED, WATERLOGGED});
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

