/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import com.mcwwindows.kikoz.util.WindowPart;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GothicWindow
extends WindowBase {
    public static final EnumProperty<WindowPart> PART = EnumProperty.func_177709_a((String)"part", WindowPart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    protected static final VoxelShape EAST = VoxelShapes.func_216384_a((VoxelShape)GothicWindow.func_208617_a((double)3.0, (double)0.0, (double)-1.0, (double)13.0, (double)16.0, (double)17.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = VoxelShapes.func_216384_a((VoxelShape)GothicWindow.func_208617_a((double)-1.0, (double)0.0, (double)3.0, (double)17.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);

    public GothicWindow(AbstractBlock.Properties properties) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(1.5f, 3.0f).func_226896_b_().func_235861_h_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)WindowPart.BASE)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                return EAST;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return NORTH;
            }
        }
        return NORTH;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.WindowState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING, WATERLOGGED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public void openDoor(World worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.func_203425_a((Block)this) && (Boolean)state.func_177229_b((Property)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == ItemInit.HAMMER.get()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_235896_a_(PART));
            return ActionResultType.SUCCESS;
        }
        Boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        if (open.booleanValue()) {
            this.garageDoor(worldIn, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING), 1000);
            worldIn.func_184133_a(null, pos, (SoundEvent)SoundsInit.BARS_OPEN.get(), SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
            state = (BlockState)state.func_235896_a_((Property)OPEN);
            worldIn.func_180501_a(pos, state, 10);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205359_a(currentPos, (Object)Fluids.field_204546_a);
        }
        return super.func_196271_a(stateIn, facing, facingState, (IWorld)worldIn, currentPos, facingPos);
    }

    @Override
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207188_f() : super.func_204507_t(state);
    }

    private void garageDoor(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            boolean open = (Boolean)state.func_177229_b((Property)OPEN);
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 6);
                this.garageDoor(world, pos.func_177965_g(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177985_f(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(1).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(1).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(2).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(2).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177981_b(1).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177981_b(1).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177970_e(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177964_d(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(1).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(1).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(2).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177979_c(2).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177981_b(1).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.func_177981_b(1).func_177964_d(1), targetOpen, targetDirection, depth - 2);
            }
        }
    }
}

