/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkTicket {
    private final ServerWorld level;
    private final ChunkPos pos;
    private final Set<IChunkLoader> loaders = new HashSet<IChunkLoader>();

    public ChunkTicket(ServerWorld level, ChunkPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public boolean addLoader(IChunkLoader loader) {
        boolean empty = this.loaders.isEmpty();
        if (this.loaders.add(loader)) {
            ForgeChunkManager.forceChunk((ServerWorld)this.level, (String)"chickenchunks", (BlockPos)loader.pos(), (int)this.pos.field_77276_a, (int)this.pos.field_77275_b, (boolean)true, (boolean)true);
        }
        return empty;
    }

    public boolean remLoader(IChunkLoader loader) {
        if (this.loaders.remove(loader)) {
            ForgeChunkManager.forceChunk((ServerWorld)this.level, (String)"chickenchunks", (BlockPos)loader.pos(), (int)this.pos.field_77276_a, (int)this.pos.field_77275_b, (boolean)false, (boolean)true);
        }
        return this.loaders.isEmpty();
    }

    public Set<IChunkLoader> getLoaders() {
        return Collections.unmodifiableSet(this.loaders);
    }
}

