/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.proxy;

import codechicken.chunkloader.client.ChunkLoaderItemModel;
import codechicken.chunkloader.client.TileChunkLoaderRenderer;
import codechicken.chunkloader.init.ModContent;
import codechicken.chunkloader.proxy.Proxy;
import codechicken.lib.model.ModelRegistryHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ProxyClient
extends Proxy {
    private static final ModelRegistryHelper modelHelper = new ModelRegistryHelper();

    @Override
    public void clientSetup(FMLClientSetupEvent event) {
        super.clientSetup(event);
        ClientRegistry.bindTileEntityRenderer(ModContent.tileChunkLoaderType, TileChunkLoaderRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModContent.tileSpotLoaderType, TileChunkLoaderRenderer::new);
        modelHelper.registerCallback(e -> {
            IBakedModel loaderModel = (IBakedModel)e.getModelRegistry().get(new ModelResourceLocation(ModContent.blockChunkLoader.getRegistryName(), ""));
            IBakedModel spotModel = (IBakedModel)e.getModelRegistry().get(new ModelResourceLocation(ModContent.blockSpotLoader.getRegistryName(), ""));
            e.getModelRegistry().put(new ModelResourceLocation(ModContent.itemChunkLoader.getRegistryName(), "inventory"), new ChunkLoaderItemModel(loaderModel, false));
            e.getModelRegistry().put(new ModelResourceLocation(ModContent.itemSpotLoader.getRegistryName(), "inventory"), new ChunkLoaderItemModel(spotModel, true));
        });
    }
}

