/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;

public final class SpecificModsTargetingRule
implements ITargetingRule {
    private final Collection<String> mods;

    private SpecificModsTargetingRule(Collection<String> mods) {
        this.mods = mods;
    }

    public static SpecificModsTargetingRule of(Collection<String> mods) {
        if (mods.isEmpty()) {
            throw new IllegalArgumentException("Unable to create a specific mods targeting rule without any targets");
        }
        return new SpecificModsTargetingRule(mods);
    }

    public static SpecificModsTargetingRule of(String ... mods) {
        return SpecificModsTargetingRule.of(new HashSet<String>(Arrays.asList(mods)));
    }

    @Override
    public boolean shouldBeReplaced(IRecipe<?> recipe, IRecipeManager manager) {
        return this.mods.contains(recipe.func_199560_c().func_110624_b());
    }

    @Override
    public String describe() {
        return this.mods.stream().collect(Collectors.joining(", ", "recipes from mods {", "}"));
    }
}

