/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class ExcludingRecipesAndDelegatingTargetingRule
implements ITargetingRule {
    private final ITargetingRule delegate;
    private final Collection<ResourceLocation> exclusions;

    private ExcludingRecipesAndDelegatingTargetingRule(ITargetingRule delegate, Collection<ResourceLocation> exclusions) {
        this.delegate = delegate;
        this.exclusions = exclusions;
    }

    public static ExcludingRecipesAndDelegatingTargetingRule of(ITargetingRule delegate, Collection<ResourceLocation> exclusions) {
        Objects.requireNonNull(delegate);
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Unable to create an exclusion for recipes without any recipe to exclude");
        }
        if (delegate instanceof ExcludingRecipesAndDelegatingTargetingRule) {
            ExcludingRecipesAndDelegatingTargetingRule delegatingRule = (ExcludingRecipesAndDelegatingTargetingRule)delegate;
            return ExcludingRecipesAndDelegatingTargetingRule.of(delegatingRule.delegate, (Collection)Util.func_200696_a(new HashSet<ResourceLocation>(exclusions), it -> it.addAll(delegatingRule.exclusions)));
        }
        return new ExcludingRecipesAndDelegatingTargetingRule(delegate, exclusions);
    }

    public static ExcludingRecipesAndDelegatingTargetingRule of(ITargetingRule delegate, ResourceLocation ... exclusions) {
        return ExcludingRecipesAndDelegatingTargetingRule.of(delegate, new HashSet<ResourceLocation>(Arrays.asList(exclusions)));
    }

    public static ExcludingRecipesAndDelegatingTargetingRule of(ITargetingRule delegate, WrapperRecipe ... exclusions) {
        return ExcludingRecipesAndDelegatingTargetingRule.of(delegate, Arrays.stream(exclusions).map(WrapperRecipe::getRecipe).map(IRecipe::func_199560_c).collect(Collectors.toSet()));
    }

    @Override
    public boolean shouldBeReplaced(IRecipe<?> recipe, IRecipeManager manager) {
        return !this.exclusions.contains(recipe.func_199560_c()) && this.delegate.shouldBeReplaced(recipe, manager);
    }

    @Override
    public String describe() {
        return String.format("%s, but excluding recipes {%s}", this.delegate.describe(), this.exclusions.stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
    }
}

