/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.recipes.SerializerShapeless;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CTRecipeShapeless
implements ICraftingRecipe {
    private final IIngredient[] ingredients;
    private final IItemStack output;
    @Nullable
    private final IRecipeManager.RecipeFunctionArray function;
    private final ResourceLocation resourceLocation;

    public CTRecipeShapeless(String name, IItemStack output, IIngredient[] ingredients, @Nullable IRecipeManager.RecipeFunctionArray function) {
        this.resourceLocation = new ResourceLocation("crafttweaker", name);
        this.output = output;
        this.function = function;
        boolean containsNull = false;
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null) continue;
            CraftTweakerAPI.logWarning("Shapeless recipe with ID '%s' contains null ingredient, removing entries!", this.resourceLocation);
            containsNull = true;
            break;
        }
        if (containsNull) {
            ingredients = (IIngredient[])Arrays.stream(ingredients).filter(Objects::nonNull).toArray(IIngredient[]::new);
        }
        this.ingredients = ingredients;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean[] visited = this.forAllUniqueMatches((IInventory)inv, (ingredientIndex, matchingSlot, stack) -> {});
        int visitedCount = 0;
        for (int slot = 0; slot < visited.length; ++slot) {
            if (visited[slot]) {
                ++visitedCount;
                continue;
            }
            if (inv.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return visitedCount == this.ingredients.length;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        if (this.function == null) {
            return this.output.getInternal().func_77946_l();
        }
        IItemStack[] stacks = new IItemStack[this.ingredients.length];
        this.forAllUniqueMatches((IInventory)inv, (ingredientIndex, matchingSlot, stack) -> {
            stacks[ingredientIndex] = stack.setAmount(1);
        });
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    @Nullable
    public IRecipeManager.RecipeFunctionArray getFunction() {
        return this.function;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.ingredients.length;
    }

    public ItemStack func_77571_b() {
        return this.output.getInternal().func_77946_l();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.forAllUniqueMatches((IInventory)inv, (ingredientIndex, matchingSlot, stack) -> {
            ItemStack cfr_ignored_0 = (ItemStack)remainingItems.set(matchingSlot, (Object)this.ingredients[ingredientIndex].getRemainingItem(stack).getInternal());
        });
        return remainingItems;
    }

    private boolean[] forAllUniqueMatches(IInventory inv, ForAllUniqueAction action) {
        boolean[] visited = new boolean[inv.func_70302_i_()];
        block0: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ingredients[ingredientIndex];
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                MCItemStack stack;
                ItemStack stackInSlot;
                if (visited[i] || (stackInSlot = inv.func_70301_a(i)).func_190926_b() || !ingredient.matches(stack = new MCItemStack(stackInSlot))) continue;
                visited[i] = true;
                action.accept(ingredientIndex, i, stack);
                continue block0;
            }
        }
        return visited;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (IIngredient ingredient : this.ingredients) {
            ingredients.add((Object)ingredient.asVanillaIngredient());
        }
        return ingredients;
    }

    public boolean func_192399_d() {
        return false;
    }

    public String func_193358_e() {
        return super.func_193358_e();
    }

    public ResourceLocation func_199560_c() {
        return this.resourceLocation;
    }

    public IRecipeSerializer<CTRecipeShapeless> func_199559_b() {
        return SerializerShapeless.INSTANCE;
    }

    public IRecipeType<?> func_222127_g() {
        return IRecipeType.field_222149_a;
    }

    public IIngredient[] getCtIngredients() {
        return this.ingredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    private static interface ForAllUniqueAction {
        public void accept(int var1, int var2, IItemStack var3);
    }
}

