/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionRemoveAllGenericRecipes;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionRemoveGenericRecipeByInput;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionRemoveGenericRecipeByModId;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionRemoveGenericRecipeByName;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionRemoveGenericRecipeByOutput;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionRemoveGenericRecipeByRegex;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.managers.RecipeManagerWrapper;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/managers/GenericRecipesManager")
@ZenCodeType.Name(value="crafttweaker.api.GenericRecipesManager")
public class GenericRecipesManager {
    @ZenCodeGlobals.Global(value="recipes")
    public static final GenericRecipesManager RECIPES = new GenericRecipesManager();

    @ZenCodeType.Method
    public void addJSONRecipe(String name, IData data) {
        if (!(data instanceof MapData)) {
            throw new IllegalArgumentException("Json recipe's IData should be a MapData!");
        }
        JsonObject recipeObject = (JsonObject)IRecipeManager.JSON_RECIPE_GSON.fromJson(data.toJsonString(), JsonObject.class);
        if (!recipeObject.has("type")) {
            throw new IllegalArgumentException("Serializer type missing!");
        }
        if (recipeObject.get("type").getAsString().equals("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Cannot add a recipe to the CraftTweaker Scripts recipe type!");
        }
        ResourceLocation recipeName = new ResourceLocation("crafttweaker", name);
        IRecipe result = RecipeManager.func_215377_a((ResourceLocation)recipeName, (JsonObject)recipeObject);
        RecipeManagerWrapper recipeManagerWrapper = new RecipeManagerWrapper(result.func_222127_g());
        CraftTweakerAPI.apply(new ActionAddRecipe(recipeManagerWrapper, result, null));
    }

    @ZenCodeType.Method
    public WrapperRecipe getRecipeByName(String name) {
        WrapperRecipe recipe = this.getRecipeMap().get(new ResourceLocation(name));
        if (recipe == null) {
            throw new IllegalArgumentException("No recipe found with name: \"" + name + "\"");
        }
        return recipe;
    }

    @ZenCodeType.Method
    public List<WrapperRecipe> getRecipesByOutput(IIngredient output) {
        return this.getAllRecipes().stream().filter(iRecipe -> output.matches(iRecipe.getOutput())).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allRecipes")
    public List<WrapperRecipe> getAllRecipes() {
        return this.getAllManagers().stream().map(IRecipeManager::getAllRecipes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    public Map<ResourceLocation, WrapperRecipe> getRecipeMap() {
        return this.getAllManagers().stream().map(IRecipeManager::getRecipeMap).flatMap(recipeMap -> recipeMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByOutput(output));
    }

    @ZenCodeType.Method
    public void removeRecipeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByInput(input));
    }

    @ZenCodeType.Method
    public void removeByName(String name) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByName(name));
    }

    @ZenCodeType.Method
    public void removeByModid(String modId) {
        this.removeByModid(modId, null);
    }

    @ZenCodeType.Method
    public void removeByModid(String modId, IRecipeManager.RecipeFilter exclude) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByModId(modId, exclude));
    }

    @ZenCodeType.Method
    public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByRegex(regex));
    }

    @ZenCodeType.Method
    public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAllGenericRecipes());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allManagers")
    public List<IRecipeManager> getAllManagers() {
        return new ArrayList<IRecipeManager>(RecipeTypeBracketHandler.getManagerInstances());
    }
}

