/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.modifiers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.api.loot.modifiers.ILootModifier;
import com.blamejared.crafttweaker.api.util.MethodHandleHelper;
import com.blamejared.crafttweaker.impl.actions.loot.ActionRegisterLootModifier;
import com.blamejared.crafttweaker.impl.actions.loot.ActionRemoveLootModifier;
import com.blamejared.crafttweaker.impl.loot.conditions.CTLootConditionBuilder;
import com.blamejared.crafttweaker.impl.loot.modifiers.CraftTweakerPrivilegedLootModifierMap;
import com.blamejared.crafttweaker.impl.loot.modifiers.MCLootModifier;
import com.blamejared.crafttweaker.impl.util.NameUtils;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.modifiers.LootModifierManager")
@Document(value="vanilla/api/loot/modifiers/LootModifierManager")
public final class CTLootModifierManager {
    public static final CTLootModifierManager LOOT_MODIFIER_MANAGER = new CTLootModifierManager();
    private static final MethodHandle LMM_GETTER = MethodHandleHelper.linkMethod(ForgeInternalHandler.class, "getLootModifierManager", new Class[0]);
    private static final MethodHandle LMM_MAP_GETTER = MethodHandleHelper.linkGetter(LootModifierManager.class, "registeredLootModifiers");
    private static final MethodHandle LMM_MAP_SETTER = MethodHandleHelper.linkSetter(LootModifierManager.class, "registeredLootModifiers");

    private CTLootModifierManager() {
    }

    @ZenCodeType.Method
    public void register(String name, @ZenCodeType.Nullable ILootCondition[] conditions, ILootModifier modifier) {
        CraftTweakerAPI.apply(new ActionRegisterLootModifier(this.fromName(name), conditions == null ? new ILootCondition[]{} : conditions, modifier, this::getLmmMap));
    }

    @ZenCodeType.Method
    public void register(String name, CTLootConditionBuilder builder, ILootModifier modifier) {
        this.register(name, builder.build(), modifier);
    }

    @ZenCodeType.Method
    public void registerUnconditional(String name, ILootModifier modifier) {
        this.register(name, new ILootCondition[0], modifier);
    }

    @ZenCodeType.Method
    public ILootModifier getByName(String name) {
        return new MCLootModifier(this.getLmmMap().get(new ResourceLocation(name)));
    }

    @ZenCodeType.Method
    public List<String> getAllNames() {
        return this.getLmmMap().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    public List<ILootModifier> getAll() {
        return this.getAllNames().stream().map(this::getByName).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    public void removeByName(String name) {
        ResourceLocation id = name.contains(":") ? new ResourceLocation(name) : new ResourceLocation("crafttweaker", name);
        CraftTweakerAPI.apply(ActionRemoveLootModifier.of(arg_0 -> ((ResourceLocation)id).equals(arg_0), "with name '" + id + "'", this::getLmmMap));
    }

    @ZenCodeType.Method
    public void removeByModId(String modId) {
        CraftTweakerAPI.apply(ActionRemoveLootModifier.of(name -> modId.equals(name.func_110624_b()), "registered by the mod '" + modId + "'", this::getLmmMap));
    }

    @ZenCodeType.Method
    public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(ActionRemoveLootModifier.of(name -> name.toString().matches(regex), "matching the regular expression '" + regex + "'", this::getLmmMap));
    }

    @ZenCodeType.Method
    public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveLootModifier(ignored -> true, null, this::getLmmMap));
    }

    private Map<ResourceLocation, IGlobalLootModifier> getLmmMap() {
        try {
            LootModifierManager lmm = MethodHandleHelper.invoke(() -> LMM_GETTER.invokeExact());
            Map map = MethodHandleHelper.invoke(() -> LMM_MAP_GETTER.invokeExact(lmm));
            if (!(map instanceof CraftTweakerPrivilegedLootModifierMap)) {
                CraftTweakerPrivilegedLootModifierMap finalMap = new CraftTweakerPrivilegedLootModifierMap(map);
                map = finalMap;
                MethodHandleHelper.invokeVoid(() -> this.setLmmMap(lmm, finalMap));
            }
            return map;
        }
        catch (IllegalStateException e) {
            return Collections.emptyMap();
        }
    }

    private void setLmmMap(LootModifierManager lmm, Map<ResourceLocation, IGlobalLootModifier> map) throws Throwable {
        LMM_MAP_SETTER.invokeExact(lmm, map);
    }

    private ResourceLocation fromName(String name) {
        return NameUtils.fromFixedName(name, (fixed, mistakes) -> CraftTweakerAPI.logWarning("The given loot modifier name '%s' isn't valid due to:\n%s\nThe name was changed to '%s'", name, String.join((CharSequence)"\n", mistakes), fixed));
    }
}

