/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.io.BaseEncoding;
import dan200.computercraft.ComputerCraft;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;

public final class NBTUtil {
    private static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();

    private NBTUtil() {
    }

    private static INBT toNBTTag(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return ByteNBT.func_229671_a_((byte)((byte)((Boolean)object != false ? 1 : 0)));
        }
        if (object instanceof Number) {
            return DoubleNBT.func_229684_a_((double)((Number)object).doubleValue());
        }
        if (object instanceof String) {
            return StringNBT.func_229705_a_((String)object.toString());
        }
        if (object instanceof Map) {
            Map m = (Map)object;
            CompoundNBT nbt = new CompoundNBT();
            int i = 0;
            for (Map.Entry entry : m.entrySet()) {
                INBT key = NBTUtil.toNBTTag(entry.getKey());
                INBT value = NBTUtil.toNBTTag(entry.getKey());
                if (key == null || value == null) continue;
                nbt.func_218657_a("k" + i, key);
                nbt.func_218657_a("v" + i, value);
                ++i;
            }
            nbt.func_74768_a("len", m.size());
            return nbt;
        }
        return null;
    }

    public static CompoundNBT encodeObjects(Object[] objects) {
        if (objects == null || objects.length <= 0) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("len", objects.length);
        for (int i = 0; i < objects.length; ++i) {
            INBT child = NBTUtil.toNBTTag(objects[i]);
            if (child == null) continue;
            nbt.func_218657_a(Integer.toString(i), child);
        }
        return nbt;
    }

    private static Object fromNBTTag(INBT tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.func_74732_a()) {
            case 1: {
                return ((ByteNBT)tag).func_150290_f() > 0;
            }
            case 6: {
                return ((DoubleNBT)tag).func_150286_g();
            }
            default: {
                return tag.func_150285_a_();
            }
            case 10: 
        }
        CompoundNBT c = (CompoundNBT)tag;
        int len = c.func_74762_e("len");
        HashMap<Object, Object> map = new HashMap<Object, Object>(len);
        for (int i = 0; i < len; ++i) {
            Object key = NBTUtil.fromNBTTag(c.func_74781_a("k" + i));
            Object value = NBTUtil.fromNBTTag(c.func_74781_a("v" + i));
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Object toLua(INBT tag) {
        if (tag == null) {
            return null;
        }
        byte typeID = tag.func_74732_a();
        switch (typeID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((NumberNBT)tag).func_150291_c();
            }
            case 5: 
            case 6: {
                return ((NumberNBT)tag).func_150286_g();
            }
            case 8: {
                return tag.func_150285_a_();
            }
            case 10: {
                CompoundNBT compound = (CompoundNBT)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.func_186856_d());
                for (String key : compound.func_150296_c()) {
                    Object value = NBTUtil.toLua(compound.func_74781_a(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                return map;
            }
            case 9: {
                ListNBT list = (ListNBT)tag;
                HashMap<Integer, Object> map = new HashMap<Integer, Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    map.put(i, NBTUtil.toLua(list.get(i)));
                }
                return map;
            }
            case 7: {
                byte[] array = ((ByteArrayNBT)tag).func_150292_c();
                HashMap<Integer, Byte> map = new HashMap<Integer, Byte>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(i + 1, array[i]);
                }
                return map;
            }
            case 11: {
                int[] array = ((IntArrayNBT)tag).func_150302_c();
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(i + 1, array[i]);
                }
                return map;
            }
        }
        return null;
    }

    public static Object[] decodeObjects(CompoundNBT tag) {
        int len = tag.func_74762_e("len");
        if (len <= 0) {
            return null;
        }
        Object[] objects = new Object[len];
        for (int i = 0; i < len; ++i) {
            String key = Integer.toString(i);
            if (!tag.func_74764_b(key)) continue;
            objects[i] = NBTUtil.fromNBTTag(tag.func_74781_a(key));
        }
        return objects;
    }

    @Nullable
    public static String getNBTHash(@Nullable CompoundNBT tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NBTUtil.writeTag(output, "", (INBT)tag);
            byte[] hash = digest.digest();
            return ENCODING.encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            ComputerCraft.log.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static void writeTag(DataOutput output, String name, INBT tag) throws IOException {
        output.writeByte(tag.func_74732_a());
        if (tag.func_74732_a() == 0) {
            return;
        }
        output.writeUTF(name);
        if (tag instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)tag;
            Object[] keys = compound.func_150296_c().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                NBTUtil.writeTag(output, (String)key, compound.func_74781_a((String)key));
            }
            output.writeByte(0);
        } else {
            tag.func_74734_a(output);
        }
    }

    private static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }
    }
}

