/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.SidedCaps;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class TileWiredModemFull
extends TileGeneric {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private final SidedCaps<IPeripheral> modemCaps = SidedCaps.ofNonNull(this::getPeripheral);
    private boolean peripheralAccessAllowed = false;
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this.tickToken));
    private final WiredModemElement element = new FullElement(this);
    private LazyOptional<IWiredElement> elementCap;
    private final IWiredNode node = this.element.getNode();
    private final NonNullConsumer<LazyOptional<IWiredElement>> connectedNodeChanged = x -> this.connectionsChanged();
    private int invalidSides = 0;

    public TileWiredModemFull(TileEntityType<TileWiredModemFull> type) {
        super(type);
        for (int i = 0; i < this.peripherals.length; ++i) {
            Direction facing = Direction.func_82600_a((int)i);
            this.peripherals[i] = new WiredModemLocalPeripheral(() -> this.queueRefreshPeripheral(facing));
        }
    }

    private void doRemove() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.doRemove();
        }
        super.destroy();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.doRemove();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        this.modemCaps.invalidate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.doRemove();
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        this.onNeighbourTileEntityChange(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (!this.field_145850_b.field_72995_K && this.peripheralAccessAllowed) {
            for (Direction facing : DirectionUtil.FACINGS) {
                if (!this.func_174877_v().func_177972_a(facing).equals((Object)neighbour)) continue;
                this.queueRefreshPeripheral(facing);
            }
        }
    }

    private void queueRefreshPeripheral(@Nonnull Direction facing) {
        if (this.invalidSides == 0) {
            TickScheduler.schedule(this.tickToken);
        }
        this.invalidSides |= 1 << facing.ordinal();
    }

    private void refreshPeripheral(@Nonnull Direction facing) {
        this.invalidSides &= ~(1 << facing.ordinal());
        WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
        if (this.field_145850_b != null && !this.func_145837_r() && peripheral.attach(this.field_145850_b, this.func_174877_v(), facing)) {
            this.updateConnectedPeripherals();
        }
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_213453_ef() || !player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        if (this.func_145831_w().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Set<String> oldPeriphNames = this.getConnectedPeripheralNames();
        this.togglePeripheralAccess();
        Set<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equal(periphNames, oldPeriphNames)) {
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return ActionResultType.SUCCESS;
    }

    private static void sendPeripheralChanges(PlayerEntity player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        StringTextComponent base = new StringTextComponent("");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.func_240702_b_(", ");
            }
            base.func_230529_a_((ITextComponent)ChatHelpers.copy((String)names.get(i)));
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent(kind, new Object[]{base}), false);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.peripheralAccessAllowed = nbt.func_74767_n(NBT_PERIPHERAL_ENABLED);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74757_a(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        return super.func_189515_b(nbt);
    }

    private void updateBlockState() {
        BlockState state = this.func_195044_w();
        boolean modemOn = this.modemState.isOpen();
        boolean peripheralOn = this.peripheralAccessAllowed;
        if ((Boolean)state.func_177229_b((Property)BlockWiredModemFull.MODEM_ON) == modemOn && (Boolean)state.func_177229_b((Property)BlockWiredModemFull.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)((BlockState)state.func_206870_a((Property)BlockWiredModemFull.MODEM_ON, (Comparable)Boolean.valueOf(modemOn))).func_206870_a((Property)BlockWiredModemFull.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    public void onLoad() {
        super.onLoad();
        TickScheduler.schedule(this.tickToken);
    }

    @Override
    public void blockTick() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(direction);
            }
        }
        if (this.modemState.pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                for (Direction facing : DirectionUtil.FACINGS) {
                    this.peripherals[facing.ordinal()].attach(this.field_145850_b, this.func_174877_v(), facing);
                }
                this.updateConnectedPeripherals();
            }
        }
    }

    private void connectionsChanged() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        World world = this.func_145831_w();
        BlockPos current = this.func_174877_v();
        for (Direction facing : DirectionUtil.FACINGS) {
            LazyOptional<IWiredElement> element;
            BlockPos offset = current.func_177972_a(facing);
            if (!world.isAreaLoaded(offset, 0) || !(element = ComputerCraftAPI.getWiredElementAt((IBlockReader)world, offset, facing.func_176734_d())).isPresent()) continue;
            element.addListener(this.connectedNodeChanged);
            this.node.connectTo(((IWiredElement)element.orElseThrow(NullPointerException::new)).getNode());
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            boolean hasAny = false;
            for (Direction facing : DirectionUtil.FACINGS) {
                WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
                peripheral.attach(this.field_145850_b, this.func_174877_v(), facing);
                hasAny |= peripheral.hasPeripheral();
            }
            if (!hasAny) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.getConnectedPeripherals());
        } else {
            this.peripheralAccessAllowed = false;
            for (WiredModemLocalPeripheral peripheral : this.peripherals) {
                peripheral.detach();
            }
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private Set<String> getConnectedPeripheralNames() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptySet();
        }
        HashSet<String> peripherals = new HashSet<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        return peripherals;
    }

    private Map<String, IPeripheral> getConnectedPeripherals() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptyMap();
        }
        HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            peripheral.extendMap(peripherals);
        }
        return peripherals;
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.getConnectedPeripherals();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.CAPABILITY_WIRED_ELEMENT) {
            if (this.elementCap == null) {
                this.elementCap = LazyOptional.of(() -> this.element);
            }
            return this.elementCap.cast();
        }
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.modemCaps.get(side).cast();
        }
        return super.getCapability(capability, side);
    }

    public IWiredElement getElement() {
        return this.element;
    }

    private WiredModemPeripheral getPeripheral(final @Nonnull Direction side) {
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        final WiredModemLocalPeripheral localPeripheral = this.peripherals[side.ordinal()];
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element){

            @Override
            @Nonnull
            protected WiredModemLocalPeripheral getLocalPeripheral() {
                return localPeripheral;
            }

            @Override
            @Nonnull
            public Vector3d getPosition() {
                return Vector3d.func_237489_a_((Vector3i)TileWiredModemFull.this.func_174877_v().func_177972_a(side));
            }

            @Override
            @Nonnull
            public Object getTarget() {
                return TileWiredModemFull.this;
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final TileWiredModemFull entity;

        private FullElement(TileWiredModemFull entity) {
            this.entity = entity;
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.entity.func_145831_w();
        }

        @Override
        @Nonnull
        public Vector3d getPosition() {
            return Vector3d.func_237489_a_((Vector3i)this.entity.func_174877_v());
        }
    }
}

