/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.gui.ComputerScreenBase;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkMessage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class UploadResultMessage
implements NetworkMessage {
    private final int containerId;
    private final UploadResult result;
    private final ITextComponent errorMessage;

    private UploadResultMessage(Container container, UploadResult result, @Nullable ITextComponent errorMessage) {
        this.containerId = container.field_75152_c;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public static UploadResultMessage queued(Container container) {
        return new UploadResultMessage(container, UploadResult.QUEUED, null);
    }

    public static UploadResultMessage consumed(Container container) {
        return new UploadResultMessage(container, UploadResult.CONSUMED, null);
    }

    public static UploadResultMessage error(Container container, ITextComponent errorMessage) {
        return new UploadResultMessage(container, UploadResult.ERROR, errorMessage);
    }

    public UploadResultMessage(@Nonnull PacketBuffer buf) {
        this.containerId = buf.func_150792_a();
        this.result = (UploadResult)buf.func_179257_a(UploadResult.class);
        this.errorMessage = this.result == UploadResult.ERROR ? buf.func_179258_d() : null;
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        buf.func_150787_b(this.containerId);
        buf.func_179249_a((Enum)this.result);
        if (this.result == UploadResult.ERROR) {
            buf.func_179256_a(this.errorMessage);
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Screen screen = OptionScreen.unwrap(minecraft.field_71462_r);
        if (screen instanceof ComputerScreenBase && ((ContainerComputerBase)((ComputerScreenBase)screen).func_212873_a_()).field_75152_c == this.containerId) {
            ((ComputerScreenBase)screen).uploadResult(this.result, this.errorMessage);
        }
    }
}

