/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.IUpgradeBase;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class UpgradeRecipeGenerator<T> {
    private static final ResourceLocation TURTLE_UPGRADE = new ResourceLocation("computercraft", "turtle_upgrade");
    private static final ResourceLocation POCKET_UPGRADE = new ResourceLocation("computercraft", "pocket_upgrade");
    private final Function<ICraftingRecipe, T> wrap;
    private final Map<Item, List<UpgradeInfo>> upgradeItemLookup = new HashMap<Item, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<ICraftingRecipe, T> wrap) {
        this.wrap = wrap;
    }

    private void setupCache() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        TurtleUpgrades.getUpgrades().forEach(upgrade -> {
            ItemStack stack = upgrade.getCraftingItem();
            if (stack.func_190926_b()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, (ITurtleUpgrade)upgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.func_77973_b(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        });
        PocketUpgrades.getUpgrades().forEach(upgrade -> {
            ItemStack stack = upgrade.getCraftingItem();
            if (stack.func_190926_b()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, (IPocketUpgrade)upgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.func_77973_b(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        });
    }

    public boolean isUpgrade(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.func_77973_b());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.func_190926_b() || craftingStack.func_77973_b() != stack.func_77973_b() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(ItemStack stack) {
        this.setupCache();
        if (stack.func_77973_b() instanceof ItemTurtle) {
            ItemTurtle item = (ItemTurtle)stack.func_77973_b();
            ITurtleUpgrade left = item.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return Collections.emptyList();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (left == null) {
                    recipes.add(this.turtle(ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, upgrade.turtle, right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, upgrade.turtle)));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.func_77973_b() instanceof ItemPocketComputer) {
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                return Collections.emptyList();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                recipes.add(this.pocket(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.pocketWith(stack, upgrade.pocket)));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.func_77973_b());
        if (upgrades == null) {
            return Collections.emptyList();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.func_190926_b() || craftingStack.func_77973_b() != stack.func_77973_b() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? Collections.emptyList() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemTurtle) {
            ItemTurtle item = (ItemTurtle)stack.func_77973_b();
            ArrayList<T> recipes = new ArrayList<T>(0);
            ITurtleUpgrade left = item.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, null, right)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{left.getCraftingItem()}), stack));
            }
            if (right != null) {
                recipes.add(this.turtle(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{right.getCraftingItem()}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, left, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.func_77973_b() instanceof ItemPocketComputer) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                recipes.add(this.pocket(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{back.getCraftingItem()}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.pocketWith(stack, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return Collections.emptyList();
    }

    private static ItemStack turtleWith(ItemStack stack, @Nullable ITurtleUpgrade left, @Nullable ITurtleUpgrade right) {
        ItemTurtle item = (ItemTurtle)stack.func_77973_b();
        return TurtleItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), left, right, item.getFuelLevel(stack), item.getOverlay(stack));
    }

    private static ItemStack pocketWith(ItemStack stack, @Nullable IPocketUpgrade back) {
        ItemPocketComputer item = (ItemPocketComputer)stack.func_77973_b();
        return PocketComputerItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), back);
    }

    private T pocket(Ingredient upgrade, Ingredient pocketComputer, ItemStack result) {
        return this.wrap.apply((ICraftingRecipe)new ShapedRecipe(POCKET_UPGRADE, "", 1, 2, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{upgrade, pocketComputer}), result));
    }

    private T turtle(Ingredient left, Ingredient right, ItemStack result) {
        return this.wrap.apply((ICraftingRecipe)new ShapedRecipe(TURTLE_UPGRADE, "", 2, 1, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{left, right}), result));
    }

    private class UpgradeInfo {
        final ItemStack stack;
        final Ingredient ingredient;
        @Nullable
        final ITurtleUpgrade turtle;
        @Nullable
        final IPocketUpgrade pocket;
        final IUpgradeBase upgrade;
        @Nullable
        private ArrayList<T> recipes;

        UpgradeInfo(ItemStack stack, ITurtleUpgrade turtle) {
            this.stack = stack;
            this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            this.turtle = turtle;
            this.upgrade = this.turtle;
            this.pocket = null;
        }

        UpgradeInfo(ItemStack stack, IPocketUpgrade pocket) {
            this.stack = stack;
            this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            this.turtle = null;
            this.pocket = pocket;
            this.upgrade = this.pocket;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            for (ComputerFamily family : RecipeModHelpers.MAIN_FAMILIES) {
                if (this.turtle != null) {
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null)}), TurtleItemFactory.create(-1, null, -1, family, null, this.turtle, 0, null)));
                }
                if (this.pocket == null) continue;
                recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PocketComputerItemFactory.create(-1, null, -1, family, null)}), PocketComputerItemFactory.create(-1, null, -1, family, this.pocket)));
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

