/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.ServerTableFormatter;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class TableBuilder {
    private final int id;
    private int columns = -1;
    private final ITextComponent[] headers;
    private final ArrayList<ITextComponent[]> rows = new ArrayList();
    private int additional;

    public TableBuilder(int id, ITextComponent ... headers) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be positive");
        }
        this.id = id;
        this.headers = headers;
        this.columns = headers.length;
    }

    public TableBuilder(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be positive");
        }
        this.id = id;
        this.headers = null;
    }

    public TableBuilder(int id, String ... headers) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be positive");
        }
        this.id = id;
        this.headers = new ITextComponent[headers.length];
        this.columns = headers.length;
        for (int i = 0; i < headers.length; ++i) {
            this.headers[i] = ChatHelpers.header(headers[i]);
        }
    }

    public void row(ITextComponent ... row) {
        if (this.columns == -1) {
            this.columns = row.length;
        }
        if (row.length != this.columns) {
            throw new IllegalArgumentException("Row is the incorrect length");
        }
        this.rows.add(row);
    }

    public int getId() {
        return this.id;
    }

    public int getColumns() {
        return this.columns;
    }

    @Nullable
    public ITextComponent[] getHeaders() {
        return this.headers;
    }

    @Nonnull
    public List<ITextComponent[]> getRows() {
        return this.rows;
    }

    public int getAdditional() {
        return this.additional;
    }

    public void setAdditional(int additional) {
        this.additional = additional;
    }

    public void trim(int height) {
        if (this.rows.size() > height) {
            this.additional += this.rows.size() - height - 1;
            this.rows.subList(height - 1, this.rows.size()).clear();
        }
    }

    public void display(CommandSource source) {
        if (CommandUtils.isPlayer(source)) {
            this.trim(18);
            NetworkHandler.sendToPlayer((ServerPlayerEntity)source.func_197022_f(), new ChatTableClientMessage(this));
        } else {
            this.trim(100);
            new ServerTableFormatter(source).display(this);
        }
    }
}

