/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.mojang.datafixers.util.Pair;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(DataGenerator generator) {
        super(generator);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return Arrays.asList(Pair.of(() -> LootTableGenerator::registerBlocks, (Object)LootParameterSets.field_216267_h), Pair.of(() -> LootTableGenerator::registerGeneric, (Object)LootParameterSets.field_216266_g));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
        map.forEach((id, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)id, (LootTable)table));
    }

    private static void registerBlocks(BiConsumer<ResourceLocation, LootTable.Builder> add) {
        LootTableGenerator.namedBlockDrop(add, Registry.ModBlocks.DISK_DRIVE);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.MONITOR_NORMAL);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.MONITOR_ADVANCED);
        LootTableGenerator.namedBlockDrop(add, Registry.ModBlocks.PRINTER);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.SPEAKER);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.WIRED_MODEM_FULL);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.WIRELESS_MODEM_NORMAL);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.WIRELESS_MODEM_ADVANCED);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.COMPUTER_NORMAL);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.COMPUTER_ADVANCED);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.COMPUTER_COMMAND);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.TURTLE_NORMAL);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.TURTLE_ADVANCED);
        add.accept(((BlockCable)Registry.ModBlocks.CABLE.get()).func_220068_i(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.ModItems.CABLE.get()))).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)Registry.ModBlocks.CABLE.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((Property)BlockCable.CABLE, true)))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.ModItems.WIRED_MODEM.get()))).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212840_b_(BlockStateProperty.func_215985_a((Block)((Block)Registry.ModBlocks.CABLE.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.None))).func_216298_a())));
    }

    private static void registerGeneric(BiConsumer<ResourceLocation, LootTable.Builder> add) {
        add.accept(CommonHooks.LOOT_TREASURE_DISK, LootTable.func_216119_b());
    }

    private static void selfDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> wrapper) {
        LootTableGenerator.blockDrop(add, wrapper, ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)wrapper.get())), SurvivesExplosion.func_215968_b());
    }

    private static void namedBlockDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> wrapper) {
        LootTableGenerator.blockDrop(add, wrapper, ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)wrapper.get())).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)), SurvivesExplosion.func_215968_b());
    }

    private static void computerDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> block) {
        LootTableGenerator.blockDrop(add, block, DynamicLootEntry.func_216162_a((ResourceLocation)new ResourceLocation("computercraft", "computer")), (ILootCondition.IBuilder)Alternative.func_215960_a((ILootCondition.IBuilder[])new ILootCondition.IBuilder[]{BlockNamedEntityLootCondition.BUILDER, HasComputerIdLootCondition.BUILDER, PlayerCreativeLootCondition.BUILDER.func_216298_a()}));
    }

    private static void blockDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> wrapper, LootEntry.Builder<?> drop, ILootCondition.IBuilder condition) {
        Block block = wrapper.get();
        add.accept(block.func_220068_i(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(drop).func_212840_b_(condition)));
    }
}

