/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.Registry;
import java.util.Optional;
import net.minecraft.data.ItemModelProvider;
import net.minecraft.data.ModelTextures;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.data.ModelsUtil;
import net.minecraft.data.StockModelShapes;
import net.minecraft.data.StockTextureAliases;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public final class ItemModelGenerator {
    private ItemModelGenerator() {
    }

    public static void addItemModels(ItemModelProvider generators) {
        ItemModelGenerator.registerDisk(generators, (Item)Registry.ModItems.DISK.get());
        ItemModelGenerator.registerDisk(generators, (Item)Registry.ModItems.TREASURE_DISK.get());
        ItemModelGenerator.registerPocketComputer(generators, ModelsResourceUtil.func_240219_a_((Item)((Item)Registry.ModItems.POCKET_COMPUTER_NORMAL.get())), false);
        ItemModelGenerator.registerPocketComputer(generators, ModelsResourceUtil.func_240219_a_((Item)((Item)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get())), false);
        ItemModelGenerator.registerPocketComputer(generators, new ResourceLocation("computercraft", "item/pocket_computer_colour"), true);
        generators.func_240076_a_((Item)Registry.ModItems.PRINTED_BOOK.get(), StockModelShapes.field_240273_aK_);
        generators.func_240076_a_((Item)Registry.ModItems.PRINTED_PAGE.get(), StockModelShapes.field_240273_aK_);
        generators.func_240076_a_((Item)Registry.ModItems.PRINTED_PAGES.get(), StockModelShapes.field_240273_aK_);
    }

    private static void registerPocketComputer(ItemModelProvider generators, ResourceLocation id, boolean off) {
        ItemModelGenerator.createFlatItem(generators, ItemModelGenerator.addSuffix(id, "_blinking"), new ResourceLocation("computercraft", "item/pocket_computer_blink"), id, new ResourceLocation("computercraft", "item/pocket_computer_light"));
        ItemModelGenerator.createFlatItem(generators, ItemModelGenerator.addSuffix(id, "_on"), new ResourceLocation("computercraft", "item/pocket_computer_on"), id, new ResourceLocation("computercraft", "item/pocket_computer_light"));
        if (off) {
            ItemModelGenerator.createFlatItem(generators, id, new ResourceLocation("computercraft", "item/pocket_computer_frame"), id);
        }
    }

    private static void registerDisk(ItemModelProvider generators, Item item) {
        ItemModelGenerator.createFlatItem(generators, item, new ResourceLocation("computercraft", "item/disk_frame"), new ResourceLocation("computercraft", "item/disk_colour"));
    }

    private static void createFlatItem(ItemModelProvider generators, Item item, ResourceLocation ... ids) {
        ItemModelGenerator.createFlatItem(generators, ModelsResourceUtil.func_240219_a_((Item)item), ids);
    }

    private static void createFlatItem(ItemModelProvider generators, ResourceLocation model, ResourceLocation ... textures) {
        if (textures.length > 5) {
            throw new IndexOutOfBoundsException("Too many layers");
        }
        if (textures.length == 0) {
            throw new IndexOutOfBoundsException("Must have at least one texture");
        }
        if (textures.length == 1) {
            StockModelShapes.field_240273_aK_.func_240234_a_(model, ModelTextures.func_240376_j_((ResourceLocation)textures[0]), generators.field_240073_a_);
            return;
        }
        StockTextureAliases[] slots = new StockTextureAliases[textures.length];
        ModelTextures mapping = new ModelTextures();
        for (int i = 0; i < textures.length; ++i) {
            StockTextureAliases slot = slots[i] = StockTextureAliases.func_240431_a_((String)("layer" + i));
            mapping.func_240349_a_(slot, textures[i]);
        }
        new ModelsUtil(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), slots).func_240234_a_(model, mapping, generators.field_240073_a_);
    }

    private static ResourceLocation addSuffix(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + suffix);
    }
}

