/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.ClientInputHandler;
import dan200.computercraft.client.gui.ItemToast;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.DynamicImageButton;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ComputerScreenBase<T extends ContainerComputerBase>
extends ContainerScreen<T> {
    private static final ITextComponent OK = new TranslationTextComponent("gui.ok");
    private static final ITextComponent NO_RESPONSE_TITLE = new TranslationTextComponent("gui.computercraft.upload.no_response");
    private static final ITextComponent NO_RESPONSE_MSG = new TranslationTextComponent("gui.computercraft.upload.no_response.msg", new Object[]{new StringTextComponent("import").func_240699_a_(TextFormatting.DARK_GRAY)});
    protected WidgetTerminal terminal;
    protected Terminal terminalData;
    protected final ComputerFamily family;
    protected final InputHandler input;
    protected final int sidebarYOffset;
    private long uploadNagDeadline = Long.MAX_VALUE;
    private final ItemStack displayStack;

    public ComputerScreenBase(T container, PlayerInventory player, ITextComponent title, int sidebarYOffset) {
        super(container, player, title);
        this.terminalData = ((ContainerComputerBase)container).getTerminal();
        this.family = ((ContainerComputerBase)container).getFamily();
        this.displayStack = ((ContainerComputerBase)container).getDisplayStack();
        this.input = new ClientInputHandler(this.field_147002_h);
        this.sidebarYOffset = sidebarYOffset;
    }

    protected abstract WidgetTerminal createTerminal();

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.terminal = (WidgetTerminal)this.func_230480_a_(this.createTerminal());
        ComputerSidebar.addButtons((Screen)this, ((ContainerComputerBase)this.field_147002_h)::isOn, this.input, arg_0 -> ((ComputerScreenBase)this).func_230480_a_(arg_0), this.field_147003_i, this.field_147009_r + this.sidebarYOffset);
        this.func_231035_a_((IGuiEventListener)this.terminal);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.terminal.update();
        if (this.uploadNagDeadline != Long.MAX_VALUE && Util.func_211178_c() >= this.uploadNagDeadline) {
            new ItemToast(this.field_230706_i_, this.displayStack, NO_RESPONSE_TITLE, NO_RESPONSE_MSG, ItemToast.TRANSFER_NO_RESPONSE_TOKEN).showOrReplace(this.field_230706_i_.func_193033_an());
            this.uploadNagDeadline = Long.MAX_VALUE;
        }
    }

    public boolean func_231046_a_(int key, int scancode, int modifiers) {
        if (key == 258 && this.func_241217_q_() != null && this.func_241217_q_() == this.terminal) {
            return this.func_241217_q_().func_231046_a_(key, scancode, modifiers);
        }
        return super.func_231046_a_(key, scancode, modifiers);
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        boolean changed = super.func_231044_a_(x, y, button);
        if (this.func_241217_q_() instanceof DynamicImageButton) {
            this.func_231035_a_((IGuiEventListener)this.terminal);
        }
        return changed;
    }

    public boolean func_231045_a_(double x, double y, int button, double deltaX, double deltaY) {
        return this.func_241217_q_() != null && this.func_241217_q_().func_231045_a_(x, y, button, deltaX, deltaY) || super.func_231045_a_(x, y, button, deltaX, deltaY);
    }

    protected void func_230451_b_(@Nonnull MatrixStack transform, int mouseX, int mouseY) {
    }

    public void func_230476_a_(@Nonnull List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        if (!((ContainerComputerBase)this.field_147002_h).isOn()) {
            this.alert(UploadResult.FAILED_TITLE, UploadResult.COMPUTER_OFF_MSG);
            return;
        }
        long size = 0L;
        ArrayList<FileUpload> toUpload = new ArrayList<FileUpload>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(file, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    long fileSize = sbc.size();
                    if (fileSize > 524288L || (size += fileSize) >= 524288L) {
                        this.alert(UploadResult.FAILED_TITLE, UploadResult.TOO_MUCH_MSG);
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (name.length() > 128) {
                        this.alert(UploadResult.FAILED_TITLE, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.failed.name_too_long"));
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.allocateDirect((int)fileSize);
                    sbc.read(buffer);
                    buffer.flip();
                    byte[] digest = FileUpload.getDigest(buffer);
                    if (digest == null) {
                        this.alert(UploadResult.FAILED_TITLE, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.failed.corrupted"));
                        return;
                    }
                    toUpload.add(new FileUpload(name, buffer, digest));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sbc == null) continue;
                    if (throwable != null) {
                        try {
                            sbc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    sbc.close();
                }
            }
            catch (IOException e) {
                ComputerCraft.log.error("Failed uploading files", (Throwable)e);
                this.alert(UploadResult.FAILED_TITLE, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.failed.generic", new Object[]{"Cannot compute checksum"}));
            }
        }
        if (toUpload.size() > 32) {
            this.alert(UploadResult.FAILED_TITLE, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.failed.too_many_files"));
            return;
        }
        if (toUpload.size() > 0) {
            UploadFileMessage.send(this.field_147002_h, toUpload, NetworkHandler::sendToServer);
        }
    }

    public void uploadResult(UploadResult result, @Nullable ITextComponent message) {
        switch (result) {
            case QUEUED: {
                if (ComputerCraft.uploadNagDelay <= 0) break;
                this.uploadNagDeadline = Util.func_211178_c() + TimeUnit.SECONDS.toNanos(ComputerCraft.uploadNagDelay);
                break;
            }
            case CONSUMED: {
                this.uploadNagDeadline = Long.MAX_VALUE;
                break;
            }
            case ERROR: {
                this.alert(UploadResult.FAILED_TITLE, message);
            }
        }
    }

    private void alert(ITextComponent title, ITextComponent message) {
        OptionScreen.show(this.field_230706_i_, title, message, Collections.singletonList(OptionScreen.newButton(OK, b -> this.field_230706_i_.func_147108_a((Screen)this))), () -> this.field_230706_i_.func_147108_a((Screen)this));
    }
}

