/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import javax.annotation.Nullable;
import net.minecraft.inventory.container.Container;

public final class ClientInputHandler
implements InputHandler {
    private final Container menu;

    public ClientInputHandler(Container menu) {
        this.menu = menu;
    }

    @Override
    public void turnOn() {
        NetworkHandler.sendToServer(new ComputerActionServerMessage(this.menu, ComputerActionServerMessage.Action.TURN_ON));
    }

    @Override
    public void shutdown() {
        NetworkHandler.sendToServer(new ComputerActionServerMessage(this.menu, ComputerActionServerMessage.Action.SHUTDOWN));
    }

    @Override
    public void reboot() {
        NetworkHandler.sendToServer(new ComputerActionServerMessage(this.menu, ComputerActionServerMessage.Action.REBOOT));
    }

    @Override
    public void queueEvent(String event, @Nullable Object[] arguments) {
        NetworkHandler.sendToServer(new QueueEventServerMessage(this.menu, event, arguments));
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        NetworkHandler.sendToServer(new KeyEventServerMessage(this.menu, repeat ? 1 : 0, key));
    }

    @Override
    public void keyUp(int key) {
        NetworkHandler.sendToServer(new KeyEventServerMessage(this.menu, 2, key));
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.menu, 0, button, x, y));
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.menu, 2, button, x, y));
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.menu, 1, button, x, y));
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.menu, 3, direction, x, y));
    }
}

