/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.FalseCraftingInventory;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.xp.EmptyXpStorage;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.CrafterRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachineCrafterContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MachineCrafterTile
extends MachineTileProcess {
    public static final int SLOT_CRAFTING_START = 11;
    protected FalseCraftingInventory craftMatrix = new FalseCraftingInventory(3, 3);
    protected CraftResultInventory craftResult = new CraftResultInventory();
    protected boolean hasRecipeChanges;
    protected boolean validRecipe;
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected ItemStorageCoFH resultSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && CrafterRecipeManager.instance().validFluid(fluid, this.curRecipe));

    public MachineCrafterTile() {
        super(TExpReferences.MACHINE_CRAFTER_TILE);
        this.xpStorage = EmptyXpStorage.INSTANCE;
        this.inventory.addSlots(StorageGroup.INPUT, 9, item -> item.func_77973_b() instanceof SlotSealItem || this.filter.valid(item) && CrafterRecipeManager.instance().validItem(item, this.curRecipe));
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.inventory.addSlots(StorageGroup.INTERNAL, 9);
        this.inventory.addSlot(this.resultSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return CrafterRecipeManager.instance().getBasePower();
    }

    public void func_73660_a() {
        if (!this.resultSlot.isEmpty() && this.craftResult.func_193055_i() == null) {
            this.setRecipe();
        }
        super.func_73660_a();
    }

    protected int getBaseXpStorage() {
        return 0;
    }

    protected void setRecipe() {
        ICraftingRecipe craftRecipe;
        if (this.field_145850_b == null || Utils.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.craftMatrix.func_70299_a(i, this.inventory.get(11 + i));
        }
        Optional possibleRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, this.field_145850_b);
        if (possibleRecipe.isPresent()) {
            craftRecipe = (ICraftingRecipe)possibleRecipe.get();
            this.craftResult.func_70299_a(0, craftRecipe.func_77572_b((IInventory)this.craftMatrix));
        } else {
            craftRecipe = null;
            this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
            if (this.isActive) {
                this.processOff();
            }
        }
        this.craftResult.func_193056_a((IRecipe)craftRecipe);
        this.curRecipe = CrafterRecipeManager.instance().getRecipe((IRecipe)craftRecipe);
        this.resultSlot.setItemStack(this.craftResult.func_70301_a(0));
        this.clearRecipeChanges();
    }

    public void markRecipeChanges() {
        this.hasRecipeChanges = true;
        if (this.isActive) {
            this.processOff();
        }
    }

    public void clearRecipeChanges() {
        this.hasRecipeChanges = false;
    }

    public boolean hasRecipeChanges() {
        return this.hasRecipeChanges;
    }

    public void onReplaced(BlockState state, World worldIn, BlockPos pos, BlockState newState) {
        int i;
        if (!((Boolean)ThermalConfig.keepItems.get()).booleanValue()) {
            for (i = 0; i < this.invSize() - this.augSize() - 9 - 1; ++i) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(i));
            }
        }
        if (!((Boolean)ThermalConfig.keepAugments.get()).booleanValue()) {
            for (i = this.invSize() - this.augSize(); i < this.invSize(); ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (World)worldIn, (BlockPos)pos);
            }
        }
    }

    protected boolean canProcessStart() {
        return !this.hasRecipeChanges && super.canProcessStart();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = CrafterRecipeManager.instance().getRecipe(this.craftResult.func_193055_i());
        if (this.curRecipe != null) {
            Pair inputCounts = this.curRecipe.getInputItemAndFluidCounts((IMachineInventory)this);
            this.itemInputCounts = (List)inputCounts.getLeft();
            this.fluidInputCounts = (List)inputCounts.getRight();
        }
        this.validRecipe = !this.itemInputCounts.isEmpty() || !this.fluidInputCounts.isEmpty();
        return this.validRecipe;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = !this.fluidInputCounts.isEmpty() && (Integer)this.fluidInputCounts.get(0) > 0 ? new FluidStack(this.inputTank.getFluidStack(), 1000) : FluidStack.EMPTY;
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineCrafterContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    public PacketBuffer getConfigPacket(PacketBuffer buffer) {
        super.getConfigPacket(buffer);
        for (int i = 11; i < 20; ++i) {
            buffer.func_150788_a(this.inventory.getStackInSlot(i));
        }
        return buffer;
    }

    public void handleConfigPacket(PacketBuffer buffer) {
        super.handleConfigPacket(buffer);
        for (int i = 11; i < 20; ++i) {
            this.inventory.set(i, buffer.func_150791_c());
        }
        this.setRecipe();
    }

    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        boolean hasRecipe = this.craftResult.func_193055_i() != null;
        buffer.writeBoolean(hasRecipe);
        if (hasRecipe) {
            buffer.func_192572_a(this.craftResult.func_193055_i().func_199560_c());
        }
        return buffer;
    }

    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        if (buffer.readBoolean() && this.field_145850_b != null) {
            Optional possibleRecipe = this.field_145850_b.func_199532_z().func_215367_a(buffer.func_192575_l());
            possibleRecipe.ifPresent(recipe -> {
                this.curRecipe = CrafterRecipeManager.instance().getRecipe(recipe);
            });
        } else {
            this.curRecipe = null;
        }
    }
}

