/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.tileentity.TackleBoxTileEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class TackleBoxRenderer<T extends TackleBoxTileEntity>
extends TileEntityRenderer<T> {
    private static final ResourceLocation TACKLE_BOX_TEXTURE = new ResourceLocation("aquaculture", "textures/entity/tileentity/tackle_box.png");
    private static final RenderType TACKLE_BOX_RENDER = RenderType.func_228638_b_((ResourceLocation)TACKLE_BOX_TEXTURE);
    private final ModelRenderer base;
    private final ModelRenderer lid = new ModelRenderer(64, 32, 0, 0);
    private final ModelRenderer handle;

    public TackleBoxRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.lid.func_78793_a(7.0f, 12.0f, 4.0f);
        this.lid.func_228301_a_(-7.0f, -3.0f, -8.0f, 14.0f, 3.0f, 8.0f, 0.0f);
        this.base = new ModelRenderer(64, 32, 0, 11);
        this.base.func_78793_a(0.0f, 18.0f, 4.0f);
        this.base.func_228301_a_(0.0f, -6.0f, -8.0f, 14.0f, 6.0f, 8.0f, 0.0f);
        this.handle = new ModelRenderer(64, 32, 36, 0);
        this.handle.func_78793_a(0.0f, 0.0f, 0.0f);
        this.handle.func_228301_a_(-2.0f, -4.0f, -5.0f, 4.0f, 1.0f, 2.0f, 0.0f);
        this.lid.func_78792_a(this.handle);
    }

    public void render(@Nonnull T tackleBox, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = tackleBox.func_145831_w();
        boolean hasWorld = world != null;
        BlockState state = hasWorld ? tackleBox.func_195044_w() : (BlockState)AquaBlocks.TACKLE_BOX.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        Block block = state.func_177230_c();
        if (block instanceof TackleBoxBlock) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            float facing = ((Direction)state.func_177229_b((Property)TackleBoxBlock.FACING)).func_185119_l();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            matrixStack.func_227861_a_(0.0625, 1.125, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-180.0f));
            TileEntityMerger.ICallbackWrapper callbackWrapper = TileEntityMerger.ICallback::func_225537_b_;
            float angle = ((TackleBoxTileEntity)((Object)tackleBox)).getLidAngle(partialTicks);
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            int brightness = ((Int2IntFunction)callbackWrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLight);
            IVertexBuilder tackleBoxBuilder = buffer.getBuffer(TACKLE_BOX_RENDER);
            this.render(matrixStack, tackleBoxBuilder, this.base, this.lid, angle, brightness, combinedOverlay);
            matrixStack.func_227865_b_();
        }
    }

    private void render(MatrixStack matrixStack, IVertexBuilder builder, ModelRenderer base, ModelRenderer lid, float angle, int brightness, int combinedOverlay) {
        lid.field_78795_f = -(angle * 1.5707964f);
        base.func_228308_a_(matrixStack, builder, brightness, combinedOverlay);
        lid.func_228308_a_(matrixStack, builder, brightness, combinedOverlay);
    }
}

