/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.repack.bml.utils.text;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextUtil {
    public static String capitaliseFirstLetterFully(String text) {
        if (TextUtil.isNullOrEmpty(text)) {
            return "";
        }
        return Arrays.stream(text.split(" ")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String text) {
        return !TextUtil.isNullOrEmpty(text);
    }

    public static String getFormattedText(ITextComponent textComponent) {
        StringBuilder stringbuilder = new StringBuilder();
        String s = "";
        Iterator iterator = TextUtil.stream(textComponent).iterator();
        while (iterator.hasNext()) {
            ITextComponent itextcomponent = (ITextComponent)iterator.next();
            String s1 = itextcomponent.func_150261_e();
            if (s1.isEmpty()) continue;
            String s2 = TextUtil.getFormattingCode(itextcomponent.func_150256_b());
            if (!s2.equals(s)) {
                if (!s.isEmpty()) {
                    stringbuilder.append(TextFormatting.RESET);
                }
                stringbuilder.append(s2);
                s = s2;
            }
            stringbuilder.append(s1);
        }
        if (!s.isEmpty()) {
            stringbuilder.append(TextFormatting.RESET);
        }
        return stringbuilder.toString();
    }

    private static String getFormattingCode(Style style) {
        if (style.func_150229_g()) {
            return "";
        }
        StringBuilder stringbuilder = new StringBuilder();
        if (style.func_240711_a_() != null) {
            String name = style.func_240711_a_().field_240741_d_;
            if (TextUtil.isNotNullOrEmpty(name)) {
                stringbuilder.append(TextFormatting.func_96300_b((String)name));
            } else {
                stringbuilder.append((Object)style.func_240711_a_().func_240747_b_());
            }
        }
        if (style.func_150223_b()) {
            stringbuilder.append(TextFormatting.BOLD);
        }
        if (style.func_150242_c()) {
            stringbuilder.append(TextFormatting.ITALIC);
        }
        if (style.func_150234_e()) {
            stringbuilder.append(TextFormatting.UNDERLINE);
        }
        if (style.func_150233_f()) {
            stringbuilder.append(TextFormatting.OBFUSCATED);
        }
        if (style.func_150236_d()) {
            stringbuilder.append(TextFormatting.STRIKETHROUGH);
        }
        return stringbuilder.toString();
    }

    private static Stream<ITextComponent> stream(ITextComponent textComponent) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(textComponent), textComponent.func_150253_a().stream().flatMap(i -> TextUtil.stream(i))});
    }
}

