/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.repack.bml.utils.dimension;

import com.black_dog20.servertabinfo.repack.bml.utils.text.TextUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class DimensionUtil {
    public static TextComponent getFormattedDimensionName(String dimensionName) {
        if (!dimensionName.contains(".") && !dimensionName.contains(":")) {
            String name = TextUtil.capitaliseFirstLetterFully(dimensionName.replaceAll("_", " "));
            return new StringTextComponent(name);
        }
        return new StringTextComponent(dimensionName);
    }

    public static TextComponent getFormattedDimensionName(RegistryKey<World> dimension) {
        return DimensionUtil.getFormattedDimensionName(dimension.getRegistryName(), null);
    }

    public static TextComponent getFormattedDimensionName(ResourceLocation dimensionName, String fallbackModId) {
        TranslationTextComponent name = new TranslationTextComponent(dimensionName.toString());
        if (name.getString().equals(dimensionName.toString())) {
            String alt = String.format("%s.%s", dimensionName.func_110624_b(), dimensionName.func_110623_a());
            name = new TranslationTextComponent(alt);
            if (name.getString().equals(alt) && TextUtil.isNotNullOrEmpty(fallbackModId)) {
                String fallback = String.format("%s.%s", fallbackModId, dimensionName.toString());
                name = new TranslationTextComponent(fallback);
                if (name.getString().equals(fallback)) {
                    name = DimensionUtil.getFormattedDimensionName(dimensionName.func_110623_a());
                }
            } else {
                name = DimensionUtil.getFormattedDimensionName(dimensionName.func_110623_a());
            }
        }
        return name;
    }
}

