/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.repack.bml.datagen;

import com.black_dog20.servertabinfo.repack.bml.utils.text.TextUtil;
import com.black_dog20.servertabinfo.repack.bml.utils.translate.ITranslation;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.data.LanguageProvider;

public abstract class BaseLanguageProvider
extends LanguageProvider {
    private final String modid;

    public BaseLanguageProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
        this.modid = modid;
    }

    protected void addPrefixed(String key, String text) {
        this.add(String.format("%s.%s", this.modid, key), text);
    }

    protected void addPrefixed(ITranslation translation, String text) {
        if (!this.modid.equals(translation.getModId())) {
            throw new IllegalStateException("Mod id for translation is not the same as for the generator");
        }
        this.add(translation.getDescription(), text);
    }

    protected void addPrefixed(String key, String text, TextFormatting color) {
        this.add(String.format("%s.%s", this.modid, key), TextUtil.getFormattedText((ITextComponent)new StringTextComponent(text).func_240699_a_(color)));
    }

    protected void addPrefixed(ITranslation translation, String text, TextFormatting color) {
        if (!this.modid.equals(translation.getModId())) {
            throw new IllegalStateException("Mod id for translation is not the same as for the generator");
        }
        this.add(translation.getDescription(), TextUtil.getFormattedText((ITextComponent)new StringTextComponent(text).func_240699_a_(color)));
    }

    protected String style(String text, TextFormatting ... styles) {
        return TextUtil.getFormattedText((ITextComponent)new StringTextComponent(text).func_240701_a_(styles));
    }
}

