/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client.overlays;

import com.black_dog20.servertabinfo.Config;
import com.black_dog20.servertabinfo.client.ClientDataManager;
import com.black_dog20.servertabinfo.client.keybinds.Keybinds;
import com.black_dog20.servertabinfo.common.utils.Dimension;
import com.black_dog20.servertabinfo.common.utils.Translations;
import com.black_dog20.servertabinfo.repack.bml.client.DrawingContext;
import com.black_dog20.servertabinfo.repack.bml.client.overlay.Overlay;
import com.black_dog20.servertabinfo.repack.bml.client.rows.Row;
import com.black_dog20.servertabinfo.repack.bml.client.rows.RowHelper;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.BlankColumn;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.Column;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.ITextComponentColumn;
import com.black_dog20.servertabinfo.repack.bml.utils.dimension.DimensionUtil;
import com.black_dog20.servertabinfo.repack.bml.utils.text.TextComponentBuilder;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

@OnlyIn(value=Dist.CLIENT)
public class TpsListOverlay
extends Overlay.Pre {
    private Minecraft minecraft;
    private FontRenderer fontRenderer;
    private ItemRenderer itemRenderer;
    private long lastRenderTime = Util.func_211177_b();
    private int ticks = 0;
    private int page = 1;
    private boolean hasBeenShown = false;

    public TpsListOverlay() {
        this.minecraft = Minecraft.func_71410_x();
        this.fontRenderer = this.minecraft.field_71466_p;
        this.itemRenderer = this.minecraft.func_175599_af();
    }

    @Override
    public void onRender(MatrixStack matrixStack, int width, int height) {
        int y = 10;
        int z = 0;
        if (!ClientDataManager.modOnServer) {
            this.renderNotInstalled(matrixStack, width, height, z);
        } else {
            this.renderInstalled(matrixStack, width, height, y, z);
        }
    }

    private void renderInstalled(MatrixStack matrixStack, int width, int height, int y, int z) {
        if (Util.func_211177_b() - 2000L > this.lastRenderTime) {
            this.page = 1;
            this.ticks = 1;
        }
        this.fontRenderer.getClass();
        int itemsPerPage = (int)Math.floor((height - 7 * y) / 9);
        List<Row> rows = this.getRows();
        int maxPages = (int)Math.ceil((double)rows.size() / (double)itemsPerPage);
        if (this.ticks % 300 == 0) {
            this.page = this.page >= maxPages ? 1 : ++this.page;
            this.ticks = 1;
        }
        rows = this.getPagedRows(rows, itemsPerPage);
        int maxWidth = RowHelper.getMaxWidth(rows);
        int x = width / 2 - maxWidth / 2;
        DrawingContext drawingContext = new DrawingContext(matrixStack, width, height, x, y, z, this.fontRenderer, this.itemRenderer);
        y = RowHelper.drawRowsWithBackground(drawingContext, rows);
        this.fontRenderer.func_243246_a(matrixStack, Translations.PAGE.get(this.page, maxPages), (float)(width / 2 + 2), (float)(y + 2), -1);
        ++this.ticks;
        this.lastRenderTime = Util.func_211177_b();
    }

    private void renderNotInstalled(MatrixStack matrixStack, int width, int height, int z) {
        ImmutableList rows = ImmutableList.of((Object)new Row.RowBuilder().withColumn(ITextComponentColumn.of("text", Translations.NOT_INSTALLED.get())).build());
        int maxWidth = RowHelper.getMaxWidth((List<Row>)rows);
        int x = width / 2 - maxWidth / 2;
        DrawingContext drawingContext = new DrawingContext(matrixStack, width, height, x, 30.0f, z, this.fontRenderer, this.itemRenderer);
        RowHelper.drawRowsWithBackground(drawingContext, (List<Row>)rows);
    }

    @Override
    public boolean doRender(RenderGameOverlayEvent.ElementType elementType) {
        if (elementType == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            if (Keybinds.SHOW.func_151470_d()) {
                boolean allowed = this.isAllowed();
                if (!this.hasBeenShown && !allowed) {
                    this.hasBeenShown = true;
                    Optional.ofNullable(this.minecraft.field_71439_g).ifPresent(player -> player.func_146105_b(Translations.NOT_ALLOWED.get(), true));
                }
                return allowed;
            }
            this.hasBeenShown = false;
        }
        return false;
    }

    private boolean isAllowed() {
        return (Boolean)Config.OP_ONLY_MODE.get() == false || this.minecraft.func_71356_B() || Optional.ofNullable(this.minecraft.field_71439_g).map(player -> player.func_211513_k(1)).orElse(false) != false;
    }

    @Override
    public boolean doesCancelEvent() {
        return true;
    }

    private List<Row> getRows() {
        List rows = ClientDataManager.DIMENSIONS.stream().filter(this::isNotBlocked).map(this::buildRow).collect(Collectors.toCollection(LinkedList::new));
        return rows;
    }

    private boolean isNotBlocked(Dimension dimension) {
        for (String blocked : (List)Config.DIMENSION_BLOCK_LIST.get()) {
            if (dimension.name.toString().equalsIgnoreCase(blocked.trim())) {
                return false;
            }
            if (!dimension.name.func_110624_b().equalsIgnoreCase(blocked.split(":")[0]) || !"*".equalsIgnoreCase(blocked.split(":")[1])) continue;
            return false;
        }
        return true;
    }

    private Row buildRow(Dimension dimension) {
        Row.RowBuilder builder = new Row.RowBuilder();
        return builder.withColumn(ITextComponentColumn.of("name", (ITextComponent)this.getDimensionName(dimension))).withColumn(BlankColumn.of("nameSpace", 4)).withColumn(ITextComponentColumn.of("mean", Translations.MEAN.get())).withColumn(BlankColumn.of("meanSpace", 2)).withColumn(ITextComponentColumn.of("meanNumber", (ITextComponent)this.getDimensionMean(dimension), Column.Alignment.RIGHT)).withColumn(BlankColumn.of("meanNumberSpace", 2)).withColumn(ITextComponentColumn.of("tps", (ITextComponent)this.getDimensionTps(dimension), Column.Alignment.RIGHT)).withColumn(BlankColumn.of("tpsSpace", 1)).build();
    }

    private List<Row> getPagedRows(List<Row> rows, int itemsPerPage) {
        rows = rows.stream().skip((this.page - 1) * itemsPerPage).limit(itemsPerPage).collect(Collectors.toCollection(LinkedList::new));
        return rows;
    }

    private TextComponent getDimensionName(Dimension dimension) {
        ResourceLocation dimensionName = dimension.name;
        if (ClientDataManager.DIMENSION_NAME_CACHE.containsKey(dimensionName)) {
            return ClientDataManager.DIMENSION_NAME_CACHE.get(dimensionName);
        }
        TextComponent name = DimensionUtil.getFormattedDimensionName(dimensionName, "servertabinfo");
        ClientDataManager.DIMENSION_NAME_CACHE.put(dimensionName, name);
        return name;
    }

    private TextComponent getDimensionMean(Dimension dimension) {
        double mean = dimension.meanTickTime;
        return TextComponentBuilder.of(String.format("%.2f", mean)).with(Translations.MS).build();
    }

    private TextComponent getDimensionTps(Dimension dimension) {
        int tps = dimension.tps;
        TextFormatting color = TextFormatting.GREEN;
        if (tps < 20) {
            color = TextFormatting.YELLOW;
        }
        if (tps <= 10) {
            color = TextFormatting.RED;
        }
        return TextComponentBuilder.of("(").with(tps).format(color).space().with(Translations.TPS).with(")").build();
    }
}

