/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WindSpiralParticle
extends LevelMatrixStackParticle {
    protected static final float defaultLifetime = 10.0f;
    protected float fLifetime;
    protected int seed;
    protected float yRot;
    protected float xRot;

    private WindSpiralParticle(ClientWorld level, double xPos, double yPos, double zPos, double speed, double yRot, double xRot) {
        super(level, xPos, yPos, zPos, speed, yRot, xRot);
        this.fLifetime = 10.0f / (float)speed;
        this.field_70547_e = MathHelper.ceil(this.fLifetime * 1.25f);
        this.seed = this.field_187136_p.nextInt();
        this.yRot = (float)yRot;
        this.xRot = (float)xRot;
        this.func_187115_a(1.0f, 1.0f);
        this.field_190017_n = false;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_82339_as = 0.2f * (1.0f + this.field_187136_p.nextFloat());
        this.field_70553_i = this.field_70551_j = 1.0f - 0.1f * this.field_187136_p.nextFloat();
        this.field_70552_h = this.field_70551_j;
        this.field_190015_G = this.field_190014_F = this.field_187136_p.nextFloat() * ((float)Math.PI * 2);
    }

    @Override
    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLightIn, float partialTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.field_70546_d + partialTicks - (float)rand.nextDouble(0.0, this.fLifetime * 0.25f);
        if (time < 0.0f || time > this.fLifetime) {
            return;
        }
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-this.yRot + 180.0f));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-this.xRot - 90.0f));
        stack.func_227860_a_();
        float progress = time / this.fLifetime;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        float easeSin = MathHelper.sin(progress * (float)Math.PI);
        float easePlat = MathHelper.easePlateau(progress);
        float offset = (float)rand.nextDouble(0.0, 0.8f);
        float expand = (progress + offset) * (float)rand.nextDouble(0.3f, 0.5);
        stack.func_227861_a_(0.0, (double)(expand * (float)rand.nextDouble(1.5, 2.0) - 0.75f), 0.0);
        stack.func_227862_a_(expand, offset * (float)rand.nextDouble(0.5, 1.0), expand);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.field_190014_F + progress * (float)rand.nextDouble(6.0, 9.0)));
        int rgba = VFXHelper.packRGBA(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * easeCub);
        int length = (int)(3.0f + easePlat * (float)rand.nextInt(16, 24));
        Vector4f[] poss = new Vector4f[length];
        int half = length / 2;
        for (int i = 0; i < length; ++i) {
            float rot = (float)(i - half) * 0.1309f;
            float r = 1.0f + (float)i * 0.02f;
            poss[i] = new Vector4f(r * MathHelper.cos(rot), (float)i * 0.03f, r * MathHelper.sin(rot), 1.0f);
        }
        VFXHelper.renderStreamLine(stack, buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT), packedLightIn, poss, rgba, VFXHelper.getWidthFunc((easeSin * 0.08f + 0.01f) * (float)rand.nextDouble(0.3f, 1.0)));
        stack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        public Factory(IAnimatedSprite sprite) {
        }

        @Nullable
        public Particle createParticle(BasicParticleType data, ClientWorld world, double x, double y, double z, double speed, double yRot, double xRot) {
            return new WindSpiralParticle(world, x, y, z, speed, yRot, xRot);
        }
    }
}

