/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.listbox;

import cofh.core.client.gui.element.ElementSlider;
import cofh.lib.client.gui.IGuiAccess;

public class SliderVertical
extends ElementSlider {
    public SliderVertical(IGuiAccess containerScreen, int x, int y, int width, int height, int maxValue) {
        this(containerScreen, x, y, width, height, maxValue, 0);
    }

    public SliderVertical(IGuiAccess containerScreen, int x, int y, int width, int height, int maxValue, int minValue) {
        super(containerScreen, x, y, width, height, maxValue, minValue);
        int dist = maxValue - minValue;
        this.setSliderSize(width, dist <= 0 ? height : Math.max(height / ++dist, 9));
    }

    @Override
    public ElementSlider setLimits(int min, int max) {
        int dist = max - min;
        this.setSliderSize(this.width, dist <= 0 ? this.height : Math.max(this.height / ++dist, 9));
        return super.setLimits(min, max);
    }

    @Override
    public int getSliderY() {
        int dist = this._valueMax - this._valueMin;
        int maxPos = this.height - this._sliderHeight;
        return Math.min(dist == 0 ? 0 : maxPos * (this._value - this._valueMin) / dist, maxPos);
    }

    @Override
    public void dragSlider(int x, int v) {
        v += Math.round((float)this._sliderHeight * ((float)v / (float)this.height) + (float)this._sliderHeight * 0.25f);
        this.setValue(this._valueMin + (this._valueMax - this._valueMin) * v / this.height);
    }
}

