/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.common.command;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.server.command.ChunkGenWorker;

class UpgradedChunkGenWorker
extends ChunkGenWorker {
    private final ServerWorld dimension;

    public UpgradedChunkGenWorker(CommandSource listener, BlockPos chunkcenter, int chunksize, ServerWorld dimension) {
        super(listener, chunkcenter, chunksize * chunksize, dimension, -1);
        this.dimension = dimension;
    }

    protected Queue<BlockPos> buildQueue() {
        ArrayDeque<BlockPos> ret = new ArrayDeque<BlockPos>();
        ret.add(this.start);
        int radius = (int)(Math.sqrt(this.total) / 2.0);
        for (int x = this.start.func_177958_n() - radius; x < this.start.func_177958_n() + radius; ++x) {
            for (int z = this.start.func_177952_p() - radius; z < this.start.func_177952_p() + radius; ++z) {
                ret.add(new BlockPos(x, 0, z));
            }
        }
        return ret;
    }

    public TextComponent getStartMessage(CommandSource sender) {
        return new TranslationTextComponent("mdecore.command.mde.generate.start", new Object[]{Math.sqrt(this.total), this.start.func_177958_n(), this.start.func_177952_p(), this.dimension.field_73011_w.field_240900_c_});
    }
}

