/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.jaopcaorechunks;

import com.rcx.jaopcaorechunks.OreSwapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule
public class OrechunkModule
implements IModule {
    private final IForm oreChunkForm = ApiImpl.INSTANCE.newForm((IModule)this, "ore_chunks", (IFormType)ItemFormType.INSTANCE).setMaterialTypes(new MaterialType[]{MaterialType.INGOT});
    public static IForm oreChunks;
    public List<String> materialTags = Arrays.asList("forge:ores/");
    public List<String> otherTags = Arrays.asList(new String[0]);

    public String getName() {
        return "ore_chunks";
    }

    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.oreChunkForm.toRequest());
    }

    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        config.getDefinedStringList("orechunks.materialtags", this.materialTags, "A list of tags the ore chunks will be added to, the material name will be added to the end of the tag");
        config.getDefinedStringList("orechunks.othertags", this.otherTags, "A list of tags the ore chunks will be added to");
    }

    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        for (IMaterial material : configs.keySet()) {
            OreSwapper.materialDroprates.put(material, configs.get(material).getDefinedInt("orechunks.droprate", 1, "The amount of ore chunks that drop from this ore"));
            int[] XPDrops = new int[]{configs.get(material).getDefinedInt("orechunks.minxp", 1, "The minimal amount of xp dropped from this ore"), configs.get(material).getDefinedInt("orechunks.maxxp", 4, "The maximal amount of xp dropped from this ore")};
            OreSwapper.XPDroprates.put(material, XPDrops);
        }
    }

    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        oreChunks = this.oreChunkForm;
        ApiImpl api = ApiImpl.INSTANCE;
        for (IMaterial material : this.oreChunkForm.getMaterials()) {
            IItemInfo chunkInfo = ItemFormType.INSTANCE.getMaterialFormInfo(this.oreChunkForm, material);
            ResourceLocation materialLocation = MiscHelper.INSTANCE.getTagLocation(material.getType().getFormName(), material.getName());
            api.registerSmeltingRecipe(new ResourceLocation("jaopcaorechunks", "ore_chunks.to_material." + material.getName()), (Object)chunkInfo, (Object)materialLocation, 1, 0.7f, 200);
            api.registerBlastingRecipe(new ResourceLocation("jaopcaorechunks", "ore_chunks.to_material_blasting." + material.getName()), (Object)chunkInfo, (Object)materialLocation, 1, 0.7f, 100);
            for (String tag : this.materialTags) {
                api.registerItemTag(new ResourceLocation(tag + material.getName()), chunkInfo.func_199767_j());
            }
            for (String tag : this.otherTags) {
                api.registerItemTag(new ResourceLocation(tag), chunkInfo.func_199767_j());
            }
        }
    }
}

