/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.jaopcaorechunks;

import com.google.gson.JsonObject;
import com.rcx.jaopcaorechunks.OrechunkModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.world.BlockEvent;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.MiscHelper;

public class OreSwapper
extends LootModifier {
    public static Map<IMaterial, Integer> materialDroprates = new HashMap<IMaterial, Integer>();
    public static Map<IMaterial, int[]> XPDroprates = new HashMap<IMaterial, int[]>();

    protected OreSwapper(ILootCondition[] conditionsIn) {
        super(conditionsIn);
        MinecraftForge.EVENT_BUS.addListener(this::dropXP);
    }

    private void dropXP(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockState state = event.getState();
        if (player != null && state != null && state.func_235714_a_((ITag)Tags.Blocks.ORES)) {
            Item blockItem = state.func_177230_c().func_199767_j();
            MiscHelper miscHelper = MiscHelper.INSTANCE;
            for (IMaterial material : OrechunkModule.oreChunks.getMaterials()) {
                ITag oreTag = miscHelper.getItemTag(miscHelper.getTagLocation("ores", material.getName()));
                if (!blockItem.func_206844_a(oreTag)) continue;
                int[] XP = XPDroprates.get(material);
                event.setExpToDrop(event.getExpToDrop() + event.getWorld().func_201674_k().nextInt(XP[1] - XP[0]) + XP[0]);
            }
        }
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (state != null && state.func_235714_a_((ITag)Tags.Blocks.ORES)) {
            Item blockItem = state.func_177230_c().func_199767_j();
            MiscHelper miscHelper = MiscHelper.INSTANCE;
            for (IMaterial material : OrechunkModule.oreChunks.getMaterials()) {
                IItemInfo chunkInfo = ItemFormType.INSTANCE.getMaterialFormInfo(OrechunkModule.oreChunks, material);
                ITag oreTag = miscHelper.getItemTag(miscHelper.getTagLocation("ores", material.getName()));
                if (!blockItem.func_206844_a(oreTag)) continue;
                for (ItemStack stack : generatedLoot) {
                    if (!stack.func_77973_b().func_206844_a(oreTag)) continue;
                    int amount = this.randomCount(stack.func_190916_E() * materialDroprates.get(material), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((ItemStack)context.func_216031_c(LootParameters.field_216289_i))), (World)context.func_202879_g());
                    generatedLoot.remove(stack);
                    generatedLoot.add(new ItemStack((IItemProvider)chunkInfo.func_199767_j(), amount));
                }
            }
        }
        return generatedLoot;
    }

    public int randomCount(int baseCount, int fortuneLevel, World world) {
        if (fortuneLevel > 0) {
            int j = world.field_73012_v.nextInt(fortuneLevel + 4) - 3;
            if (j < 0) {
                j = 0;
            }
            return baseCount + j;
        }
        return baseCount;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<OreSwapper> {
        public OreSwapper read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new OreSwapper(conditions);
        }

        public JsonObject write(OreSwapper instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

