/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.capabilities.helpers;

import net.bdew.lib.capabilities.CapAdapters$;
import net.bdew.lib.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;

public final class FluidHelper$ {
    public static final FluidHelper$ MODULE$ = new FluidHelper$();

    public boolean hasFluidHandler(World world, BlockPos pos, Direction side) {
        return this.getFluidHandler(world, pos, side).isDefined();
    }

    public boolean hasFluidHandler(ItemStack stack) {
        return this.getFluidHandler(stack).isDefined();
    }

    public Option<IFluidHandler> getFluidHandler(World world, BlockPos pos, Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return None$.MODULE$;
        }
        LazyOptional cap = tile.getCapability(Capabilities.CAP_FLUID_HANDLER, side);
        return cap.isPresent() ? Option$.MODULE$.apply(cap.orElseGet(() -> null)) : CapAdapters$.MODULE$.get(Capabilities.CAP_FLUID_HANDLER).wrap(tile, side);
    }

    public Option<IFluidHandlerItem> getFluidHandler(ItemStack stack) {
        if (stack.func_190926_b()) {
            return None$.MODULE$;
        }
        LazyOptional cap = stack.getCapability(Capabilities.CAP_FLUID_HANDLER_ITEM, null);
        return cap.isPresent() ? Option$.MODULE$.apply(cap.orElseGet(() -> null)) : CapAdapters$.MODULE$.get(Capabilities.CAP_FLUID_HANDLER_ITEM).wrap(stack);
    }

    public FluidStack pushFluid(IFluidHandler from, IFluidHandler to, IFluidHandler.FluidAction action, int max) {
        FluidStack fluidStack;
        FluidStack drainSim = from.drain(max, IFluidHandler.FluidAction.SIMULATE);
        if (!drainSim.isEmpty()) {
            int fillSim = to.fill(drainSim.copy(), IFluidHandler.FluidAction.SIMULATE);
            if (fillSim > 0) {
                FluidStack drainSim2 = from.drain(fillSim, IFluidHandler.FluidAction.SIMULATE);
                if (!drainSim2.isEmpty()) {
                    int fillReal = to.fill(drainSim2.copy(), action);
                    if (fillReal > 0) {
                        Object object = action.execute() ? from.drain(fillReal, action) : BoxedUnit.UNIT;
                        FluidStack tmp = drainSim2.copy();
                        tmp.setAmount(fillReal);
                        fluidStack = tmp;
                    } else {
                        fluidStack = FluidStack.EMPTY;
                    }
                } else {
                    fluidStack = FluidStack.EMPTY;
                }
            } else {
                fluidStack = FluidStack.EMPTY;
            }
        } else {
            fluidStack = FluidStack.EMPTY;
        }
        return fluidStack;
    }

    public IFluidHandler.FluidAction pushFluid$default$3() {
        return IFluidHandler.FluidAction.EXECUTE;
    }

    public int pushFluid$default$4() {
        return Integer.MAX_VALUE;
    }

    private FluidHelper$() {
    }
}

