/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.tileentity;

import com.google.common.collect.Lists;
import harmonised.pmmo.events.FurnaceHandler;
import ironfurnaces.Config;
import ironfurnaces.blocks.BlockIronFurnaceBase;
import ironfurnaces.init.Registration;
import ironfurnaces.items.ItemAugment;
import ironfurnaces.items.ItemAugmentBlasting;
import ironfurnaces.items.ItemAugmentFuel;
import ironfurnaces.items.ItemAugmentSmoking;
import ironfurnaces.items.ItemAugmentSpeed;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import ironfurnaces.tileentity.FurnaceSettings;
import ironfurnaces.tileentity.LRUCache;
import ironfurnaces.tileentity.TileEntityInventory;
import ironfurnaces.util.DirectionUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.AirItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class BlockIronFurnaceTileBase
extends TileEntityInventory
implements ITickableTileEntity,
IRecipeHolder,
IRecipeHelperPopulator {
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    public static final int OUTPUT = 2;
    protected AbstractCookingRecipe curRecipe;
    private Random rand = new Random();
    public int show_inventory_settings;
    private int jovial;
    protected int timer;
    private int currentAugment;
    private int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime = this.getCookTime();
    private int recipesUsed;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    public IRecipeType<? extends AbstractCookingRecipe> recipeType;
    public FurnaceSettings furnaceSettings;
    private LRUCache<Item, Optional<AbstractCookingRecipe>> cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    private LRUCache<Item, Optional<AbstractCookingRecipe>> blasting_cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    private LRUCache<Item, Optional<AbstractCookingRecipe>> smoking_cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    public final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BlockIronFurnaceTileBase.this.furnaceBurnTime;
                }
                case 1: {
                    return BlockIronFurnaceTileBase.this.recipesUsed;
                }
                case 2: {
                    return BlockIronFurnaceTileBase.this.cookTime;
                }
                case 3: {
                    return BlockIronFurnaceTileBase.this.totalCookTime;
                }
                case 4: {
                    return BlockIronFurnaceTileBase.this.show_inventory_settings;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    BlockIronFurnaceTileBase.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    BlockIronFurnaceTileBase.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    BlockIronFurnaceTileBase.this.cookTime = value;
                    break;
                }
                case 3: {
                    BlockIronFurnaceTileBase.this.totalCookTime = value;
                    break;
                }
                case 4: {
                    BlockIronFurnaceTileBase.this.show_inventory_settings = value;
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };
    LazyOptional<? extends IItemHandler>[] invHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});

    public BlockIronFurnaceTileBase(TileEntityType<?> tileentitytypeIn) {
        super(tileentitytypeIn, 4);
        this.recipeType = IRecipeType.field_222150_b;
        this.furnaceSettings = new FurnaceSettings(){

            @Override
            public void onChanged() {
                BlockIronFurnaceTileBase.this.func_70296_d();
            }
        };
    }

    public boolean hasRecipe(ItemStack stack) {
        return this.grabRecipe(stack).isPresent();
    }

    private LRUCache<Item, Optional<AbstractCookingRecipe>> getCache() {
        ItemStack stack = this.func_70301_a(3);
        if (stack.func_77973_b() instanceof ItemAugmentBlasting && this.recipeType != IRecipeType.field_222151_c) {
            this.recipeType = IRecipeType.field_222151_c;
        }
        if (stack.func_77973_b() instanceof ItemAugmentSmoking && this.recipeType != IRecipeType.field_222152_d) {
            this.recipeType = IRecipeType.field_222152_d;
        }
        if (!(stack.func_77973_b() instanceof ItemAugmentSmoking) && !(stack.func_77973_b() instanceof ItemAugmentBlasting) && this.recipeType != IRecipeType.field_222150_b) {
            this.recipeType = IRecipeType.field_222150_b;
        }
        if (this.recipeType == IRecipeType.field_222151_c) {
            return this.blasting_cache;
        }
        if (this.recipeType == IRecipeType.field_222152_d) {
            return this.smoking_cache;
        }
        return this.cache;
    }

    private Optional<AbstractCookingRecipe> getRecipe(Item item) {
        return item instanceof AirItem ? Optional.empty() : Optional.ofNullable(this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null));
    }

    private Optional<AbstractCookingRecipe> grabRecipe() {
        Item item = this.func_70301_a(0).func_77973_b();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional recipe = (Optional)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    private Optional<AbstractCookingRecipe> grabRecipe(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional recipe = (Optional)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    protected int getCookTime() {
        ItemStack stack = this.func_70301_a(3);
        if (this.func_70301_a(0).func_77973_b() == Items.field_190931_a) {
            return this.totalCookTime;
        }
        int speed = this.getSpeed();
        if (speed == -1) {
            return -1;
        }
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemAugmentSpeed || stack.func_77973_b() instanceof ItemAugmentBlasting || stack.func_77973_b() instanceof ItemAugmentSmoking) {
                speed = Math.max(1, speed / 2);
            }
            if (stack.func_77973_b() instanceof ItemAugmentFuel) {
                speed = Math.max(1, (int)Math.ceil((double)speed * 1.25));
            }
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int i = (Integer)this.getCookTimeConfig().get();
        int j = this.getCache().computeIfAbsent(this.func_70301_a(0).func_77973_b(), this::getRecipe).map(AbstractCookingRecipe::func_222137_e).orElse(0);
        if (j == 0) {
            Optional<AbstractCookingRecipe> recipe = this.grabRecipe();
            j = !recipe.isPresent() ? -1 : ((AbstractCookingRecipe)recipe.orElse(null)).func_222137_e();
            this.getCache().put(this.func_70301_a(0).func_77973_b(), recipe);
            if (j == -1) {
                return -1;
            }
        }
        if (j < i) {
            int k = j - (200 - i);
            return k;
        }
        return i;
    }

    public ForgeConfigSpec.IntValue getCookTimeConfig() {
        return null;
    }

    private int getAugment(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAugmentBlasting) {
            return 1;
        }
        if (stack.func_77973_b() instanceof ItemAugmentSmoking) {
            return 2;
        }
        if (stack.func_77973_b() instanceof ItemAugmentSpeed) {
            return 3;
        }
        if (stack.func_77973_b() instanceof ItemAugmentFuel) {
            return 4;
        }
        return 0;
    }

    public void forceUpdateAllStates() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue() != this.isBurning()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
        if (((Integer)state.func_177229_b((Property)BlockIronFurnaceBase.TYPE)).intValue() != this.getStateType()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(this.getStateType())), 3);
        }
        if ((Integer)state.func_177229_b((Property)BlockIronFurnaceBase.JOVIAL) != this.jovial) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(this.jovial)), 3);
        }
    }

    public void func_73660_a() {
        ItemStack stack;
        if (this.furnaceSettings.size() <= 0) {
            this.furnaceSettings = new FurnaceSettings(){

                @Override
                public void onChanged() {
                    BlockIronFurnaceTileBase.this.func_70296_d();
                }
            };
        }
        boolean wasBurning = this.isBurning();
        boolean flag1 = false;
        boolean flag2 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if ((stack = this.func_70301_a(3)).func_77973_b() instanceof ItemAugmentBlasting && this.recipeType != IRecipeType.field_222151_c) {
            this.recipeType = IRecipeType.field_222151_c;
        }
        if (stack.func_77973_b() instanceof ItemAugmentSmoking && this.recipeType != IRecipeType.field_222152_d) {
            this.recipeType = IRecipeType.field_222152_d;
        }
        if (!(stack.func_77973_b() instanceof ItemAugmentSmoking) && !(stack.func_77973_b() instanceof ItemAugmentBlasting) && this.recipeType != IRecipeType.field_222150_b) {
            this.recipeType = IRecipeType.field_222150_b;
        }
        if (!this.field_145850_b.field_72995_K) {
            int i;
            int mode;
            int get_cook_time = this.getCookTime();
            ++this.timer;
            if (this.currentAugment != this.getAugment(this.func_70301_a(3))) {
                this.currentAugment = this.getAugment(this.func_70301_a(3));
                this.furnaceBurnTime = 0;
            }
            if (this.totalCookTime != get_cook_time) {
                this.totalCookTime = get_cook_time;
            }
            if ((mode = this.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    i = 0;
                    for (Direction side : Direction.values()) {
                        if (this.field_145850_b.func_175651_c(this.field_174879_c.func_177971_a(side.func_176730_m()), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        this.cookTime = 0;
                        this.furnaceBurnTime = 0;
                        this.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (Direction side : Direction.values()) {
                        if (this.field_145850_b.func_175651_c(this.field_174879_c.func_177971_a(side.func_176730_m()), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        this.cookTime = 0;
                        this.furnaceBurnTime = 0;
                        this.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < Direction.values().length; ++i) {
                    this.provides[i] = this.func_195044_w().func_185893_b((IBlockReader)this.field_145850_b, this.field_174879_c, DirectionUtil.fromId(i));
                }
            } else {
                for (i = 0; i < Direction.values().length; ++i) {
                    this.provides[i] = 0;
                }
            }
            if (this.doesNeedUpdateSend()) {
                this.onUpdateSent();
            }
            ItemStack itemstack = (ItemStack)this.inventory.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                Optional<Object> irecipe = Optional.empty();
                if (!this.func_70301_a(0).func_190926_b()) {
                    irecipe = this.grabRecipe();
                }
                boolean valid = this.canSmelt(irecipe.orElse(null));
                if (!this.isBurning() && valid) {
                    if (itemstack.func_77973_b() instanceof ItemHeater) {
                        int energy;
                        int z;
                        int y;
                        int x;
                        TileEntity te;
                        if (itemstack.func_77942_o() && (te = this.field_145850_b.func_175625_s(new BlockPos(x = itemstack.func_77978_p().func_74762_e("X"), y = itemstack.func_77978_p().func_74762_e("Y"), z = itemstack.func_77978_p().func_74762_e("Z")))) instanceof BlockWirelessEnergyHeaterTile && (energy = ((BlockWirelessEnergyHeaterTile)te).getEnergy()) >= 2000) {
                            if (!this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentFuel) {
                                this.furnaceBurnTime = 400 * get_cook_time / 200;
                            } else if (!this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentSpeed) {
                                if (energy >= 4000) {
                                    ((BlockWirelessEnergyHeaterTile)te).removeEnergy(2000);
                                    this.furnaceBurnTime = 200 * get_cook_time / 200;
                                }
                            } else {
                                this.furnaceBurnTime = 200 * get_cook_time / 200;
                            }
                            if (this.furnaceBurnTime > 0) {
                                ((BlockWirelessEnergyHeaterTile)te).removeEnergy(2000);
                            }
                            this.recipesUsed = this.furnaceBurnTime;
                        }
                    } else {
                        this.furnaceBurnTime = !this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentFuel ? 2 * BlockIronFurnaceTileBase.getBurnTime(itemstack) * get_cook_time / 200 : (!this.func_70301_a(3).func_190926_b() && this.func_70301_a(3).func_77973_b() instanceof ItemAugmentSpeed ? BlockIronFurnaceTileBase.getBurnTime(itemstack) / 2 * get_cook_time / 200 : BlockIronFurnaceTileBase.getBurnTime(itemstack) * get_cook_time / 200);
                        this.recipesUsed = this.furnaceBurnTime;
                    }
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!(itemstack.func_77973_b() instanceof ItemHeater)) {
                            if (itemstack.hasContainerItem()) {
                                this.inventory.set(1, (Object)itemstack.getContainerItem());
                            } else if (!itemstack.func_190926_b()) {
                                itemstack.func_190918_g(1);
                                if (itemstack.func_190926_b()) {
                                    this.inventory.set(1, (Object)itemstack.getContainerItem());
                                }
                            }
                        }
                    }
                }
                if (this.isBurning() && valid) {
                    ++this.cookTime;
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem(irecipe.orElse(null));
                        this.autoIO();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (wasBurning != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
            if (this.timer % 24 == 0) {
                BlockState state;
                if (this.cookTime <= 0) {
                    if (this.func_70301_a(0).func_190926_b()) {
                        this.autoIO();
                        flag1 = true;
                    } else if (this.func_70301_a(0).func_190916_E() < this.func_70301_a(0).func_77976_d()) {
                        this.autoIO();
                        flag1 = true;
                    }
                    if (this.func_70301_a(1).func_190926_b()) {
                        this.autoIO();
                        flag1 = true;
                    } else if (this.func_70301_a(1).func_190916_E() < this.func_70301_a(1).func_77976_d()) {
                        this.autoIO();
                        flag1 = true;
                    }
                }
                if (((Integer)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((Property)BlockIronFurnaceBase.TYPE)).intValue() != this.getStateType()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(this.getStateType())), 3);
                }
                if ((Integer)state.func_177229_b((Property)BlockIronFurnaceBase.JOVIAL) != this.jovial) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(this.jovial)), 3);
                }
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private void autoIO() {
        for (Direction dir : Direction.values()) {
            IItemHandler other;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a(dir.func_176730_m()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 && this.furnaceSettings.get(dir.ordinal()) != 4 || tile == null || (other = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).map(other1 -> other1).orElse(null)) == null || other == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1) {
                ItemStack stack;
                int i;
                if (this.furnaceSettings.get(dir.ordinal()) == 1 || this.furnaceSettings.get(dir.ordinal()) == 3) {
                    if (this.func_70301_a(0).func_190916_E() >= this.func_70301_a(0).func_77976_d()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).func_190926_b() || (!this.hasRecipe(stack = other.extractItem(i, other.getStackInSlot(i).func_77976_d(), true)) || !this.func_70301_a(0).func_190926_b()) && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.func_70301_a(0), (ItemStack)stack)) continue;
                        this.insertItemInternal(0, other.extractItem(i, other.getStackInSlot(i).func_77976_d() - this.func_70301_a(0).func_190916_E(), false), false);
                    }
                }
                if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                    if (this.func_70301_a(1).func_190916_E() >= this.func_70301_a(1).func_77976_d()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).func_190926_b() || (!BlockIronFurnaceTileBase.isItemFuel(stack = other.extractItem(i, other.getStackInSlot(i).func_77976_d(), true)) || !this.func_70301_a(1).func_190926_b()) && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.func_70301_a(1), (ItemStack)stack)) continue;
                        this.insertItemInternal(1, other.extractItem(i, other.getStackInSlot(i).func_77976_d() - this.func_70301_a(1).func_190916_E(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1) continue;
            if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                ItemStack stack;
                if (this.func_70301_a(1).func_190926_b() || (stack = this.extractItemInternal(1, 1, true)).func_77973_b() != Items.field_151133_ar) continue;
                for (int i = 0; i < other.getSlots(); ++i) {
                    if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).func_190916_E() + stack.func_190916_E() > other.getSlotLimit(i))) continue;
                    other.insertItem(i, this.extractItemInternal(1, stack.func_190916_E(), false), false);
                }
            }
            if (this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || this.func_70301_a(2).func_190926_b() || tile.func_195044_w().func_177230_c().getRegistryName().toString().contains("storagedrawers:")) continue;
            for (int i = 0; i < other.getSlots(); ++i) {
                ItemStack stack = this.extractItemInternal(2, this.func_70301_a(2).func_77976_d() - other.getStackInSlot(i).func_190916_E(), true);
                if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).func_190916_E() + stack.func_190916_E() > other.getSlotLimit(i))) continue;
                other.insertItem(i, this.extractItemInternal(2, stack.func_190916_E(), false), false);
            }
        }
    }

    @Nonnull
    public ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.func_180462_a(slot, stack, null)) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.inventory.get(slot);
        int limit = stack.func_77976_d();
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.inventory.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.func_70296_d();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    private ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.func_70301_a(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.func_70299_a(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.func_70296_d();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSettingBottom() {
        return this.furnaceSettings.get(0);
    }

    public int getSettingTop() {
        return this.furnaceSettings.get(1);
    }

    public int getSettingFront() {
        int i = DirectionUtil.getId((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J));
        return this.furnaceSettings.get(i);
    }

    public int getSettingBack() {
        int i = DirectionUtil.getId(((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
        return this.furnaceSettings.get(i);
    }

    public int getSettingLeft() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (facing == Direction.NORTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.EAST));
        }
        if (facing == Direction.WEST) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.NORTH));
        }
        if (facing == Direction.SOUTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.WEST));
        }
        return this.furnaceSettings.get(DirectionUtil.getId(Direction.SOUTH));
    }

    public int getSettingRight() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (facing == Direction.NORTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.WEST));
        }
        if (facing == Direction.WEST) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.SOUTH));
        }
        if (facing == Direction.SOUTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.EAST));
        }
        return this.furnaceSettings.get(DirectionUtil.getId(Direction.NORTH));
    }

    public int getIndexFront() {
        int i = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).ordinal();
        return i;
    }

    public int getIndexBack() {
        int i = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d().ordinal();
        return i;
    }

    public int getIndexLeft() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (facing == Direction.NORTH) {
            return Direction.EAST.ordinal();
        }
        if (facing == Direction.WEST) {
            return Direction.NORTH.ordinal();
        }
        if (facing == Direction.SOUTH) {
            return Direction.WEST.ordinal();
        }
        return Direction.SOUTH.ordinal();
    }

    public int getIndexRight() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (facing == Direction.NORTH) {
            return Direction.WEST.ordinal();
        }
        if (facing == Direction.WEST) {
            return Direction.SOUTH.ordinal();
        }
        if (facing == Direction.SOUTH) {
            return Direction.EAST.ordinal();
        }
        return Direction.NORTH.ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.get(6);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.get(7);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.get(8);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.get(9);
    }

    private int getStateType() {
        if (this.func_70301_a(3).func_77973_b() == Registration.SMOKING_AUGMENT.get()) {
            return 1;
        }
        if (this.func_70301_a(3).func_77973_b() == Registration.BLASTING_AUGMENT.get()) {
            return 2;
        }
        return 0;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipe) {
        ItemStack recipeOutput;
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && recipe != null && !(recipeOutput = recipe.func_77571_b()).func_190926_b()) {
            ItemStack output = (ItemStack)this.inventory.get(2);
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(recipeOutput)) {
                return false;
            }
            return output.func_190916_E() + recipeOutput.func_190916_E() <= output.func_77976_d();
        }
        return false;
    }

    protected void smeltItem(@Nullable IRecipe<?> recipe) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.inventory.get(0);
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)this.inventory.get(2);
            if (itemstack2.func_190926_b()) {
                this.inventory.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            this.checkXP(recipe);
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.inventory.get(1)).func_190926_b() && ((ItemStack)this.inventory.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.inventory.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            if (ModList.get().isLoaded("pmmo")) {
                FurnaceHandler.handleSmelted((ItemStack)itemstack, (ItemStack)itemstack2, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)0);
                if (this.recipeType == IRecipeType.field_222152_d) {
                    FurnaceHandler.handleSmelted((ItemStack)itemstack, (ItemStack)itemstack2, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)1);
                }
            }
            itemstack.func_190918_g(1);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)this.inventory);
        this.furnaceBurnTime = tag.func_74762_e("BurnTime");
        this.cookTime = tag.func_74762_e("CookTime");
        this.totalCookTime = tag.func_74762_e("CookTimeTotal");
        this.timer = 0;
        this.currentAugment = tag.func_74762_e("Augment");
        this.jovial = tag.func_74762_e("Jovial");
        this.recipesUsed = BlockIronFurnaceTileBase.getBurnTime((ItemStack)this.inventory.get(1));
        CompoundNBT compoundnbt = tag.func_74775_l("RecipesUsed");
        for (String s : compoundnbt.func_150296_c()) {
            this.recipes.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
        this.show_inventory_settings = tag.func_74762_e("ShowInvSettings");
        this.furnaceSettings.read(tag);
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, (NonNullList)this.inventory);
        tag.func_74768_a("BurnTime", this.furnaceBurnTime);
        tag.func_74768_a("CookTime", this.cookTime);
        tag.func_74768_a("CookTimeTotal", this.totalCookTime);
        tag.func_74768_a("Augment", this.currentAugment);
        tag.func_74768_a("Jovial", this.jovial);
        tag.func_74768_a("ShowInvSettings", this.show_inventory_settings);
        this.furnaceSettings.write(tag);
        CompoundNBT compoundnbt = new CompoundNBT();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.func_74768_a(recipeId.toString(), craftedAmount.intValue()));
        tag.func_218657_a("RecipesUsed", (INBT)compoundnbt);
        return tag;
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(item, 0) : ret));
    }

    public static boolean isItemFuel(ItemStack stack) {
        return BlockIronFurnaceTileBase.getBurnTime(stack) > 0 || stack.func_77973_b() instanceof ItemHeater;
    }

    public static boolean isItemAugment(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAugment;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.func_145837_r() && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.invHandlers[0].cast();
            }
            if (facing == Direction.UP) {
                return this.invHandlers[1].cast();
            }
            if (facing == Direction.NORTH) {
                return this.invHandlers[2].cast();
            }
            if (facing == Direction.SOUTH) {
                return this.invHandlers[3].cast();
            }
            if (facing == Direction.WEST) {
                return this.invHandlers[4].cast();
            }
            return this.invHandlers[5].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 0) {
            return new int[0];
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 1) {
            return new int[]{0, 1};
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 2) {
            return new int[]{2};
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 3) {
            return new int[]{0, 1, 2};
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 4) {
            return new int[]{1};
        }
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 0) {
            return false;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 1) {
            return false;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 2) {
            return index == 2;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 3) {
            return index == 2;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.func_77973_b() != Items.field_151133_ar) {
            return false;
        }
        return this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.func_77973_b() == Items.field_151133_ar;
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (index == 2 || index == 3) {
            return false;
        }
        if (index == 0) {
            if (stack.func_190926_b()) {
                return false;
            }
            return this.hasRecipe(stack);
        }
        if (index == 1) {
            ItemStack itemstack = (ItemStack)this.inventory.get(1);
            return BlockIronFurnaceTileBase.getBurnTime(stack) > 0 || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar || stack.func_77973_b() instanceof ItemHeater;
        }
        return false;
    }

    public void setJovial(int value) {
        this.jovial = value;
    }

    public void checkXP(@Nullable IRecipe<?> recipe) {
        if (!this.field_145850_b.field_72995_K) {
            boolean flag2 = false;
            if (this.recipes.size() > (Integer)Config.furnaceXPDropValue.get()) {
                this.grantStoredRecipeExperience(this.field_145850_b, new Vector3d((double)(this.field_174879_c.func_177958_n() + this.rand.nextInt(2) - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + this.rand.nextInt(2) - 1)));
                this.recipes.clear();
            } else {
                for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                    if (!this.field_145850_b.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).isPresent() || entry.getIntValue() <= (Integer)Config.furnaceXPDropValue2.get()) continue;
                    if (!flag2) {
                        this.grantStoredRecipeExperience(this.field_145850_b, new Vector3d((double)(this.field_174879_c.func_177958_n() + this.rand.nextInt(2) - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + this.rand.nextInt(2) - 1)));
                    }
                    flag2 = true;
                }
                if (flag2) {
                    this.recipes.clear();
                }
            }
        }
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.func_199560_c();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void unlockRecipes(PlayerEntity player) {
        List<IRecipe<?>> list = this.grantStoredRecipeExperience(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(list);
        this.recipes.clear();
    }

    public List<IRecipe<?>> grantStoredRecipeExperience(World level, Vector3d worldPosition) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            level.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(h -> {
                list.add(h);
                BlockIronFurnaceTileBase.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), ((AbstractCookingRecipe)h).func_222138_b());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(World level, Vector3d worldPosition, int craftedAmount, float experience) {
        int i = MathHelper.func_76141_d((float)((float)craftedAmount * experience));
        float f = MathHelper.func_226164_h_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            level.func_217376_c((Entity)new ExperienceOrbEntity(level, worldPosition.field_72450_a, worldPosition.field_72448_b, worldPosition.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.func_194112_a(itemstack);
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    public void placeConfig() {
        if (this.furnaceSettings != null) {
            this.furnaceSettings.set(0, 2);
            this.furnaceSettings.set(1, 1);
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || dir == Direction.UP) continue;
                this.furnaceSettings.set(dir.ordinal(), 4);
            }
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176223_P(), this.field_145850_b.func_180495_p(this.field_174879_c), 3, 3);
        }
    }
}

