/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks;

import ironfurnaces.init.Registration;
import ironfurnaces.items.ItemAugment;
import ironfurnaces.items.ItemFurnaceCopy;
import ironfurnaces.items.ItemSpooky;
import ironfurnaces.items.ItemXmas;
import ironfurnaces.tileentity.BlockIronFurnaceTileBase;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BlockIronFurnaceBase
extends Block {
    public static final IntegerProperty TYPE = IntegerProperty.func_177719_a((String)"type", (int)0, (int)2);
    public static final IntegerProperty JOVIAL = IntegerProperty.func_177719_a((String)"jovial", (int)0, (int)2);

    public BlockIronFurnaceBase(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)JOVIAL, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 14 : 0;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState p_180633_3_, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)world.func_175625_s(pos);
            if (stack.func_82837_s()) {
                te.setCustomName(stack.func_151000_E());
            }
            te.totalCookTime = (Integer)te.getCookTimeConfig().get();
            te.placeConfig();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack stack = player.func_184586_b(handIn).func_77946_l();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(handIn).func_77973_b() instanceof ItemAugment && !player.func_213453_ef()) {
            return this.interactAugment(world, pos, player, handIn, stack);
        }
        if (player.func_184586_b(handIn).func_77973_b() instanceof ItemSpooky && !player.func_213453_ef()) {
            return this.interactJovial(world, pos, player, handIn, 1);
        }
        if (player.func_184586_b(handIn).func_77973_b() instanceof ItemXmas && !player.func_213453_ef()) {
            return this.interactJovial(world, pos, player, handIn, 2);
        }
        if (player.func_184586_b(handIn).func_190926_b() && player.func_213453_ef()) {
            return this.interactJovial(world, pos, player, handIn, 0);
        }
        if (player.func_184586_b(handIn).func_77973_b() instanceof ItemFurnaceCopy && !player.func_213453_ef()) {
            return this.interactCopy(world, pos, player, handIn);
        }
        this.interactWith(world, pos, player);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType interactCopy(World world, BlockPos pos, PlayerEntity player, Hand handIn) {
        int j = player.field_71071_by.field_70461_c;
        ItemStack stack = player.field_71071_by.func_70301_a(j);
        if (!(stack.func_77973_b() instanceof ItemFurnaceCopy)) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return ActionResultType.SUCCESS;
        }
        int[] settings = new int[((BlockIronFurnaceTileBase)te).furnaceSettings.size()];
        for (int i = 0; i < ((BlockIronFurnaceTileBase)te).furnaceSettings.size(); ++i) {
            settings[i] = ((BlockIronFurnaceTileBase)te).furnaceSettings.get(i);
        }
        stack.func_196082_o().func_74783_a("settings", settings);
        ((BlockIronFurnaceTileBase)te).onUpdateSent();
        player.func_145747_a((ITextComponent)new StringTextComponent("Settings copied"), player.func_110124_au());
        return ActionResultType.SUCCESS;
    }

    private ActionResultType interactAugment(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        if (!(player.func_184586_b(handIn).func_77973_b() instanceof ItemAugment)) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return ActionResultType.SUCCESS;
        }
        if (!((IInventory)te).func_70301_a(3).func_190926_b() && !player.func_184812_l_()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)((IInventory)te).func_70301_a(3));
        }
        ItemStack newStack = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
        newStack.func_77982_d(stack.func_77978_p());
        ((IInventory)te).func_70299_a(3, newStack);
        world.func_184133_a(null, te.func_174877_v(), SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            player.func_184586_b(handIn).func_190918_g(1);
        }
        ((BlockIronFurnaceTileBase)te).onUpdateSent();
        return ActionResultType.SUCCESS;
    }

    private ActionResultType interactJovial(World world, BlockPos pos, PlayerEntity player, Hand handIn, int jovial) {
        if (!(player.func_184586_b(handIn).func_77973_b() instanceof ItemSpooky) && player.func_184586_b(handIn).func_77973_b() instanceof ItemXmas && player.func_184586_b(handIn).func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return ActionResultType.SUCCESS;
        }
        ((BlockIronFurnaceTileBase)te).setJovial(jovial);
        return ActionResultType.SUCCESS;
    }

    private void interactWith(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
            if (world.func_175625_s(pos) == null) {
                return;
            }
            if (!(world.func_175625_s(pos) instanceof BlockIronFurnaceTileBase)) {
                return;
            }
            BlockIronFurnaceTileBase tile = (BlockIronFurnaceTileBase)world.func_175625_s(pos);
            if (tile.func_70301_a(3).func_77973_b() == Registration.SMOKING_AUGMENT.get()) {
                double lvt_5_1_ = (double)pos.func_177958_n() + 0.5;
                double lvt_7_1_ = pos.func_177956_o();
                double lvt_9_1_ = (double)pos.func_177952_p() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a(lvt_5_1_, lvt_7_1_, lvt_9_1_, SoundEvents.field_219691_kR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, lvt_5_1_, lvt_7_1_ + 1.1, lvt_9_1_, 0.0, 0.0, 0.0);
            } else if (tile.func_70301_a(3).func_77973_b() == Registration.BLASTING_AUGMENT.get()) {
                double lvt_5_1_ = (double)pos.func_177958_n() + 0.5;
                double lvt_7_1_ = pos.func_177956_o();
                double lvt_9_1_ = (double)pos.func_177952_p() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a(lvt_5_1_, lvt_7_1_, lvt_9_1_, SoundEvents.field_219619_am, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                Direction lvt_11_1_ = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                Direction.Axis lvt_12_1_ = lvt_11_1_.func_176740_k();
                double lvt_13_1_ = 0.52;
                double lvt_15_1_ = rand.nextDouble() * 0.6 - 0.3;
                double lvt_17_1_ = lvt_12_1_ == Direction.Axis.X ? (double)lvt_11_1_.func_82601_c() * 0.52 : lvt_15_1_;
                double lvt_19_1_ = rand.nextDouble() * 9.0 / 16.0;
                double lvt_21_1_ = lvt_12_1_ == Direction.Axis.Z ? (double)lvt_11_1_.func_82599_e() * 0.52 : lvt_15_1_;
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, lvt_5_1_ + lvt_17_1_, lvt_7_1_ + lvt_19_1_, lvt_9_1_ + lvt_21_1_, 0.0, 0.0, 0.0);
            } else {
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = pos.func_177956_o();
                double d2 = (double)pos.func_177952_p() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                Direction.Axis direction$axis = direction.func_176740_k();
                double d3 = 0.52;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
                double d6 = rand.nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public void onReplaced(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BlockIronFurnaceTileBase) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BlockIronFurnaceTileBase)te));
                ((BlockIronFurnaceTileBase)te).grantStoredRecipeExperience(world, Vector3d.func_237489_a_((Vector3i)pos));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, oldState, p_196243_5_);
        }
    }

    public boolean hasComparatorInputOverride(BlockState p_149740_1_) {
        return true;
    }

    public int getComparatorInputOverride(BlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    public BlockRenderType getRenderType(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)p_185471_1_.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    private int calculateOutput(World worldIn, BlockPos pos, BlockState state) {
        BlockIronFurnaceTileBase tile = (BlockIronFurnaceTileBase)worldIn.func_175625_s(pos);
        int i = this.getComparatorInputOverride(state, worldIn, pos);
        if (tile != null) {
            int j = tile.furnaceSettings.get(9);
            return tile.furnaceSettings.get(8) == 4 ? Math.max(i - j, 0) : i;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return super.func_176211_b(p_180656_1_, p_180656_2_, p_180656_3_, p_180656_4_);
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction direction) {
        BlockIronFurnaceTileBase furnace = (BlockIronFurnaceTileBase)world.func_175625_s(pos);
        if (furnace != null) {
            int mode = furnace.furnaceSettings.get(8);
            if (mode == 0) {
                return 0;
            }
            if (mode == 1) {
                return 0;
            }
            if (mode == 2) {
                return 0;
            }
            return this.calculateOutput(furnace.func_145831_w(), pos, blockState);
        }
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208190_q, TYPE, JOVIAL});
    }
}

