/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.datagen.loot;

import fathertoast.specialmobs.datagen.loot.LootHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;

public class LootPoolBuilder {
    private final String name;
    private RandomValueRange rolls = LootHelper.ONE_ROLL;
    private RandomValueRange bonusRolls = LootHelper.NO_ROLL;
    private final List<LootEntry.Builder<?>> lootEntries = new ArrayList();
    private final List<ILootCondition.IBuilder> poolConditions = new ArrayList<ILootCondition.IBuilder>();
    private final List<ILootFunction.IBuilder> poolFunctions = new ArrayList<ILootFunction.IBuilder>();

    public LootPoolBuilder(String id) {
        this.name = id;
    }

    public LootPool.Builder toLootPool() {
        return LootHelper.build(LootPool.func_216096_a(), this.lootEntries, this.poolConditions, this.poolFunctions).func_216046_a((IRandomRange)this.rolls).bonusRolls(this.bonusRolls.func_186509_a(), this.bonusRolls.func_186512_b()).name(this.name);
    }

    public LootPoolBuilder setRolls(float value) {
        this.rolls = new RandomValueRange(value);
        return this;
    }

    public LootPoolBuilder setRolls(float min, float max) {
        this.rolls = new RandomValueRange(min, max);
        return this;
    }

    public LootPoolBuilder setBonusRolls(float value) {
        this.bonusRolls = new RandomValueRange(value);
        return this;
    }

    public LootPoolBuilder setBonusRolls(float min, float max) {
        this.bonusRolls = new RandomValueRange(min, max);
        return this;
    }

    public LootPoolBuilder addEntry(LootEntry.Builder<?> entry) {
        this.lootEntries.add(entry);
        return this;
    }

    public LootPoolBuilder addConditions(ILootCondition.IBuilder ... conditions) {
        this.poolConditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public LootPoolBuilder addFunctions(ILootFunction.IBuilder ... functions) {
        this.poolFunctions.addAll(Arrays.asList(functions));
        return this;
    }

    public LootPoolBuilder addEntryTable(ResourceLocation lootTable) {
        return this.addEntryTable(lootTable, 1, 0, new ILootCondition.IBuilder[0]);
    }

    public LootPoolBuilder addEntryTable(ResourceLocation lootTable, int weight, int quality, ILootCondition.IBuilder ... conditions) {
        StandaloneLootEntry.Builder builder = TableLootEntry.func_216171_a((ResourceLocation)lootTable);
        for (ILootCondition.IBuilder condition : conditions) {
            builder.func_212840_b_(condition);
        }
        return this.addEntry((LootEntry.Builder<?>)builder.func_216086_a(weight).func_216085_b(quality));
    }

    public LootPoolBuilder addEntryEmpty(int weight, int quality, ILootCondition.IBuilder ... conditions) {
        StandaloneLootEntry.Builder builder = EmptyLootEntry.func_216167_a();
        for (ILootCondition.IBuilder condition : conditions) {
            builder.func_212840_b_(condition);
        }
        return this.addEntry((LootEntry.Builder<?>)builder.func_216086_a(weight).func_216085_b(quality));
    }
}

