/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.datagen.loot;

import fathertoast.specialmobs.datagen.SMLootTableProvider;
import fathertoast.specialmobs.datagen.loot.LootHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.EnchantRandomly;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public class LootEntryItemBuilder {
    private final IItemProvider item;
    private int weight = 1;
    private int quality = 0;
    private final List<ILootFunction.IBuilder> itemFunctions = new ArrayList<ILootFunction.IBuilder>();
    private final List<ILootCondition.IBuilder> entryConditions = new ArrayList<ILootCondition.IBuilder>();

    public LootEntryItemBuilder(IItemProvider baseItem) {
        this.item = baseItem;
    }

    public LootEntryItemBuilder(ItemStack itemStack) {
        this((IItemProvider)itemStack.func_77973_b());
        if (itemStack.func_77978_p() != null) {
            this.setNBTTag(itemStack.func_77978_p().func_74737_b());
        }
    }

    public LootEntry.Builder<?> toLootEntry() {
        return LootHelper.build(ItemLootEntry.func_216168_a((IItemProvider)this.item), this.entryConditions, this.itemFunctions).func_216086_a(this.weight).func_216085_b(this.quality);
    }

    public LootEntryItemBuilder setWeight(int value) {
        this.weight = value;
        return this;
    }

    public LootEntryItemBuilder setQuality(int value) {
        this.quality = value;
        return this;
    }

    public LootEntryItemBuilder addCondition(ILootCondition.IBuilder condition) {
        this.entryConditions.add(condition);
        return this;
    }

    public LootEntryItemBuilder setCount(int value) {
        return this.addFunction((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)value)));
    }

    public LootEntryItemBuilder setCount(int min, int max) {
        return this.addFunction((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max)));
    }

    public LootEntryItemBuilder addLootingBonus(float value) {
        return this.addFunction((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)new RandomValueRange(value)));
    }

    public LootEntryItemBuilder addLootingBonus(float min, float max) {
        return this.addFunction((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)new RandomValueRange(min, max)));
    }

    public LootEntryItemBuilder addLootingBonus(float min, float max, int limit) {
        return this.addFunction((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)new RandomValueRange(min, max)).func_216072_a(limit));
    }

    public LootEntryItemBuilder setDamage(int value) {
        return this.addFunction((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)new RandomValueRange((float)value)));
    }

    public LootEntryItemBuilder setDamage(int min, int max) {
        return this.addFunction((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)new RandomValueRange((float)min, (float)max)));
    }

    public LootEntryItemBuilder setNBTTag(CompoundNBT tag) {
        return this.addFunction((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)tag));
    }

    public LootEntryItemBuilder smeltIfBurning() {
        return this.addFunction((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)SMLootTableProvider.EntitySubProvider.ENTITY_ON_FIRE)));
    }

    public LootEntryItemBuilder applyOneRandomApplicableEnchant() {
        return this.addFunction((ILootFunction.IBuilder)EnchantRandomly.func_215900_c());
    }

    public LootEntryItemBuilder applyOneRandomEnchant(Enchantment ... enchantments) {
        EnchantRandomly.Builder builder = new EnchantRandomly.Builder();
        for (Enchantment enchant : enchantments) {
            builder.func_237424_a_(enchant);
        }
        return this.addFunction((ILootFunction.IBuilder)builder);
    }

    public LootEntryItemBuilder enchant(int level, boolean treasure) {
        EnchantWithLevels.Builder builder = EnchantWithLevels.func_215895_a((IRandomRange)new RandomValueRange((float)level));
        if (treasure) {
            builder.func_216059_e();
        }
        return this.addFunction((ILootFunction.IBuilder)builder);
    }

    public LootEntryItemBuilder enchant(int levelMin, int levelMax, boolean treasure) {
        EnchantWithLevels.Builder builder = EnchantWithLevels.func_215895_a((IRandomRange)new RandomValueRange((float)levelMin, (float)levelMax));
        if (treasure) {
            builder.func_216059_e();
        }
        return this.addFunction((ILootFunction.IBuilder)builder);
    }

    public LootEntryItemBuilder addFunction(ILootFunction.IBuilder function) {
        this.itemFunctions.add(function);
        return this;
    }
}

