/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.util;

import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionHelper {
    public final Entity source;
    public final World level;
    public final float radius;
    public final Explosion.Mode mode;
    public final EntityExplosionContext damageCalculator;
    public final Explosion explosion;

    public static Explosion.Mode getMode(Entity entity) {
        return ForgeEventFactory.getMobGriefingEvent((World)entity.field_70170_p, (Entity)entity) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
    }

    public static Explosion explode(Entity entity, float power, boolean damageBlocks, boolean fiery) {
        return ExplosionHelper.explode(entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), power, damageBlocks, fiery);
    }

    public static Explosion explode(Entity entity, double x, double y, double z, float power, boolean damageBlocks, boolean fiery) {
        return entity.field_70170_p.func_217398_a(entity, x, y, z, power, fiery, damageBlocks ? ExplosionHelper.getMode(entity) : Explosion.Mode.NONE);
    }

    public static void spawnLightning(World world, double x, double y, double z) {
        LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
        if (lightning != null) {
            lightning.func_225653_b_(x, y, z);
            world.func_217376_c((Entity)lightning);
        }
    }

    public ExplosionHelper(Entity entity, float power, boolean damageBlocks, boolean fiery) {
        this(entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), power, damageBlocks, fiery);
    }

    public ExplosionHelper(Entity entity, float power, Explosion.Mode explosionMode, boolean fiery) {
        this(entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), power, explosionMode, fiery);
    }

    public ExplosionHelper(Entity entity, double x, double y, double z, float power, boolean damageBlocks, boolean fiery) {
        this(entity, x, y, z, power, damageBlocks ? ExplosionHelper.getMode(entity) : Explosion.Mode.NONE, fiery);
    }

    public ExplosionHelper(Entity entity, double x, double y, double z, float power, Explosion.Mode explosionMode, boolean fiery) {
        this.source = entity;
        this.level = entity.field_70170_p;
        this.radius = power;
        this.mode = explosionMode;
        this.damageCalculator = new EntityExplosionContext(entity);
        this.explosion = new Explosion(this.level, entity, null, (ExplosionContext)this.damageCalculator, x, y, z, power, fiery, explosionMode);
    }

    public Vector3d getPos() {
        return this.explosion.getPosition();
    }

    public List<BlockPos> getHitBlocks() {
        return this.explosion.func_180343_e();
    }

    public boolean tryExplodeBlock(BlockPos pos, BlockState block, float power) {
        return this.tryExplodeBlock(pos, block, this.level.func_204610_c(pos), power);
    }

    public boolean tryExplodeBlock(BlockPos pos, BlockState block, FluidState fluid, float power) {
        float blockDamage = power * (0.7f + this.level.field_73012_v.nextFloat() * 0.6f);
        Optional<Float> optional = this.getBlockExplosionResistance(pos, block, fluid);
        if (optional.isPresent()) {
            blockDamage -= (optional.get().floatValue() + 0.3f) * 0.3f;
        }
        return blockDamage > 0.0f && this.shouldBlockExplode(pos, block, blockDamage);
    }

    public Optional<Float> getBlockExplosionResistance(BlockPos pos, BlockState block) {
        return this.damageCalculator.func_230312_a_(this.explosion, (IBlockReader)this.level, pos, block, this.level.func_204610_c(pos));
    }

    public Optional<Float> getBlockExplosionResistance(BlockPos pos, BlockState block, FluidState fluid) {
        return this.damageCalculator.func_230312_a_(this.explosion, (IBlockReader)this.level, pos, block, fluid);
    }

    public boolean shouldBlockExplode(BlockPos pos, BlockState block, float blockDamage) {
        return this.damageCalculator.func_230311_a_(this.explosion, (IBlockReader)this.level, pos, block, blockDamage);
    }

    public boolean initializeExplosion() {
        if (ForgeEventFactory.onExplosionStart((World)this.level, (Explosion)this.explosion)) {
            return false;
        }
        this.explosion.func_77278_a();
        return true;
    }

    public void finalizeExplosion() {
        if (this.level instanceof ServerWorld) {
            ServerWorld serverLevel = (ServerWorld)this.level;
            this.explosion.func_77279_a(false);
            if (this.mode == Explosion.Mode.NONE) {
                this.explosion.func_180342_d();
            }
            Vector3d pos = this.getPos();
            for (ServerPlayerEntity player : serverLevel.func_217369_A()) {
                if (!(player.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) < 4096.0)) continue;
                player.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.radius, this.explosion.func_180343_e(), (Vector3d)this.explosion.func_77277_b().get(player)));
            }
        } else {
            this.explosion.func_77279_a(true);
        }
    }
}

