/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.util;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.item.Item;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class AnnotationHelper {
    public static void injectSpeciesReference(MobFamily.Species<?> species) {
        try {
            Field field = AnnotationHelper.getField(species.entityClass, SpecialMob.SpeciesReference.class);
            field.set(null, species);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid species reference holder", ex);
        }
    }

    public static void verifySpeciesSupplier(MobFamily.Species<?> species) {
        try {
            AnnotationHelper.getNonstaticMethod(species.entityClass, SpecialMob.SpeciesSupplier.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Entity class for " + species.name + " does not override ISpecialMob#getSpecies()", ex);
        }
    }

    public static <T extends LivingEntity> BestiaryInfo.Builder getBestiaryInfo(MobFamily.Species<T> species, BestiaryInfo.Builder bestiaryInfo) {
        try {
            AnnotationHelper.getMethod(species.entityClass, SpecialMob.BestiaryInfoSupplier.class).invoke(null, bestiaryInfo);
            return bestiaryInfo;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid bestiary info method", ex);
        }
    }

    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        try {
            Method supplier = AnnotationHelper.getMethodOrSuperOptional(species.entityClass, SpecialMob.ConfigSupplier.class);
            if (supplier == null) {
                return new SpeciesConfig(species);
            }
            return (SpeciesConfig)supplier.invoke(null, species);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid config creation method", ex);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes(MobFamily.Species<?> species) {
        try {
            return (AttributeModifierMap.MutableAttribute)AnnotationHelper.getMethodOrSuper(species.entityClass, SpecialMob.AttributeSupplier.class).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid attribute creation method", ex);
        }
    }

    public static void registerSpawnPlacement(MobFamily.Species<?> species) {
        try {
            AnnotationHelper.getMethodOrSuper(species.entityClass, SpecialMob.SpawnPlacementRegistrar.class).invoke(null, species);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid spawn placement registration method", ex);
        }
    }

    public static String[] getTranslations(MobFamily.Species<?> species) {
        try {
            return (String[])AnnotationHelper.getMethod(species.entityClass, SpecialMob.LanguageProvider.class).invoke(null, ((EntityType)species.entityType.get()).func_210760_d());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid language provider method", ex);
        }
    }

    public static String[] getTranslations(Block block) {
        return AnnotationHelper.getTranslations(block, block.func_149739_a());
    }

    public static String[] getTranslations(Item item) {
        return AnnotationHelper.getTranslations(item, item.func_77658_a());
    }

    public static String[] getTranslations(ForgeRegistryEntry<?> entry, String key) {
        try {
            return (String[])AnnotationHelper.getMethod(entry.getClass(), SpecialMob.LanguageProvider.class).invoke(null, key);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Class for " + entry.getRegistryName() + " has invalid language provider method", ex);
        }
    }

    public static LootTableBuilder buildLootTable(MobFamily.Species<?> species) {
        try {
            LootTableBuilder builder = new LootTableBuilder();
            AnnotationHelper.getMethod(species.entityClass, SpecialMob.LootTableProvider.class).invoke(null, builder);
            return builder;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid loot table builder method", ex);
        }
    }

    public static <T extends LivingEntity> EntityType.IFactory<T> getEntityFactory(MobFamily.Species<T> species) {
        try {
            return (EntityType.IFactory)AnnotationHelper.getMethod(species.entityClass, SpecialMob.Factory.class).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Entity class for " + species.name + " has invalid factory provider method", ex);
        }
    }

    private static Field getField(Class<?> type, Class<? extends Annotation> annotation) throws NoSuchFieldException {
        Field field = AnnotationHelper.getFieldOptional(type, annotation);
        if (field == null) {
            throw new NoSuchFieldException(String.format("Could not find required static @%s annotated field in %s", annotation.getSimpleName(), type.getName()));
        }
        return field;
    }

    @Nullable
    private static Field getFieldOptional(Class<?> type, Class<? extends Annotation> annotation) {
        for (Field field : type.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation)) continue;
            return field;
        }
        return null;
    }

    private static Method getNonstaticMethod(Class<?> type, Class<? extends Annotation> annotation) throws NoSuchMethodException {
        for (Method method : type.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(annotation)) continue;
            return method;
        }
        throw new NoSuchMethodException(String.format("Could not find required nonstatic @%s annotated method in %s", annotation.getSimpleName(), type.getName()));
    }

    private static Method getMethod(Class<?> type, Class<? extends Annotation> annotation) throws NoSuchMethodException {
        for (Method method : type.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(annotation)) continue;
            return method;
        }
        throw new NoSuchMethodException(String.format("Could not find required static @%s annotated method in %s", annotation.getSimpleName(), type.getName()));
    }

    private static Method getMethodOrSuper(Class<? extends LivingEntity> type, Class<? extends Annotation> annotation) throws NoSuchMethodException {
        Method method = AnnotationHelper.getMethodOrSuperOptional(type, annotation);
        if (method == null) {
            throw new NoSuchMethodException(String.format("Could not find 'overridable' static @%s annotated method in %s or its parents", annotation.getSimpleName(), type.getName()));
        }
        return method;
    }

    @Nullable
    private static Method getMethodOrSuperOptional(Class<? extends LivingEntity> type, Class<? extends Annotation> annotation) {
        for (Class<? extends LivingEntity> currentType = type; currentType != LivingEntity.class; currentType = currentType.getSuperclass()) {
            for (Method method : currentType.getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(annotation)) continue;
                return method;
            }
        }
        return null;
    }
}

