/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.event;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="specialmobs")
public class PlayerVelocityWatcher {
    private static final HashMap<UUID, Entry> TRACKER = new HashMap();
    private static int cleanupCounter;

    public static Entry get(PlayerEntity player) {
        Entry trackerEntry = TRACKER.get(player.func_110124_au());
        if (trackerEntry == null) {
            trackerEntry = new Entry(player.func_213303_ch());
            TRACKER.put(player.func_110124_au(), trackerEntry);
        }
        return trackerEntry;
    }

    public static Vector3d getVelocity(Entity entity) {
        return entity instanceof PlayerEntity ? PlayerVelocityWatcher.get((PlayerEntity)entity).velocity() : entity.func_213322_ci();
    }

    @SubscribeEvent
    protected static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            Entry trackerEntry = PlayerVelocityWatcher.get(event.player);
            trackerEntry.update(event.player.func_213303_ch());
        }
    }

    @SubscribeEvent
    protected static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++cleanupCounter >= 69420) {
            cleanupCounter = 0;
            PlayerList onlinePlayers = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            TRACKER.keySet().removeIf(uuid -> onlinePlayers.func_177451_a(uuid) == null);
        }
    }

    @SubscribeEvent
    protected static void onServerStopping(FMLServerStoppingEvent event) {
        cleanupCounter = 0;
        TRACKER.clear();
    }

    public static class Entry {
        public double xPrev;
        public double yPrev;
        public double zPrev;
        public double x;
        public double y;
        public double z;

        private Entry(Vector3d pos) {
            this.reset(pos);
        }

        public double dX() {
            return this.x - this.xPrev;
        }

        public double dY() {
            return this.y - this.yPrev;
        }

        public double dZ() {
            return this.z - this.zPrev;
        }

        public Vector3d velocity() {
            return new Vector3d(this.dX(), this.dY(), this.dZ());
        }

        public boolean isMoving() {
            return Math.abs(this.dX()) > 1.0E-4 || Math.abs(this.dZ()) > 1.0E-4 || Math.abs(this.dY()) > 1.0E-4;
        }

        public void reset(Vector3d pos) {
            this.xPrev = this.x = pos.field_72450_a;
            this.yPrev = this.y = pos.field_72448_b;
            this.zPrev = this.z = pos.field_72449_c;
        }

        private void update(Vector3d pos) {
            this.xPrev = this.x;
            this.yPrev = this.y;
            this.zPrev = this.z;
            this.x = pos.field_72450_a;
            this.y = pos.field_72448_b;
            this.z = pos.field_72449_c;
        }
    }
}

