/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.event;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.entity.creeper.DrowningCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper.EnderCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper.FireCreeperEntity;
import fathertoast.specialmobs.common.entity.slime.BlueberrySlimeEntity;
import fathertoast.specialmobs.common.entity.spider.FireSpiderEntity;
import fathertoast.specialmobs.common.entity.zombie.FireZombieEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class NaturalSpawnManager {
    public static void registerSpawnPlacements() {
        if (!Config.MAIN.GENERAL.enableNaturalSpawning.get()) {
            return;
        }
        for (MobFamily.Species<?> species : MobFamily.getAllSpecies()) {
            species.registerSpawnPlacement();
        }
        if (Config.MAIN.NATURAL_SPAWNING.caveSpiderSpawnMultiplier.get() > 0.0) {
            try {
                EntitySpawnPlacementRegistry.func_209343_a((EntityType)EntityType.field_200794_h, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NaturalSpawnManager::checkSpawnRulesCaveSpider);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static void registerSpawnPlacement(MobFamily.Species<? extends MonsterEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND);
    }

    public static void registerSpawnPlacement(MobFamily.Species<? extends MonsterEntity> species, EntitySpawnPlacementRegistry.PlacementType type) {
        NaturalSpawnManager.registerSpawnPlacement(species, type, NaturalSpawnManager::checkSpawnRulesDefault);
    }

    public static <T extends MobEntity> void registerSpawnPlacement(MobFamily.Species<T> species, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        NaturalSpawnManager.registerSpawnPlacement(species, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, predicate);
    }

    public static <T extends MobEntity> void registerSpawnPlacement(MobFamily.Species<T> species, EntitySpawnPlacementRegistry.PlacementType type, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)species.entityType.get()), (EntitySpawnPlacementRegistry.PlacementType)type, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    public static boolean checkSpawnRulesDefault(EntityType<? extends MonsterEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    public static boolean checkSpawnRulesIgnoreLight(EntityType<? extends MonsterEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return MonsterEntity.func_223324_d(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    public static boolean checkSpawnRulesBasic(EntityType<? extends MobEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && MobEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    public static boolean checkSpawnRulesWater(EntityType<? extends MobEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)random) && (reason == SpawnReason.SPAWNER || world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    public static boolean checkSpawnRulesConfigured(EntityType<? extends LivingEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        MobFamily.Species<? extends LivingEntity> species;
        if (reason == SpawnReason.NATURAL && (species = MobFamily.Species.of(type)) != null && world instanceof World) {
            return species.config.GENERAL.naturalSpawnChance.rollChance(random, (World)world, pos);
        }
        return true;
    }

    public static boolean checkSpawnRulesCaveSpider(EntityType<CaveSpiderEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (reason == SpawnReason.NATURAL && world instanceof World && !Config.MAIN.NATURAL_SPAWNING.caveSpiderSpawnChance.rollChance(random, (World)world, pos)) {
            return false;
        }
        return MonsterEntity.func_223325_c(type, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (!Config.MAIN.GENERAL.enableNaturalSpawning.get()) {
            return;
        }
        MobSpawnInfoBuilder spawnInfoBuilder = event.getSpawns();
        NaturalSpawnManager.addCopiedSpawns(spawnInfoBuilder);
        NaturalSpawnManager.addBiomeCategorySpawns(spawnInfoBuilder, event.getCategory(), event.getName());
    }

    private static void addCopiedSpawns(MobSpawnInfoBuilder builder) {
        NaturalSpawnManager.addCopiedSpawns(builder, EntityType.field_200748_an, EntityType.field_200794_h, Config.MAIN.NATURAL_SPAWNING.caveSpiderSpawnMultiplier.get());
        NaturalSpawnManager.addCopiedSpawns(builder, EntityType.field_200803_q, (EntityType)EnderCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.enderCreeperSpawnMultiplier.get());
    }

    private static void addCopiedSpawns(MobSpawnInfoBuilder builder, EntityType<?> typeToCopy, EntityType<?> typeToAdd, double multi) {
        if (multi <= 0.0) {
            return;
        }
        ArrayList<MobSpawnInfo.Spawners> spawnersToCopy = new ArrayList<MobSpawnInfo.Spawners>();
        List spawners = builder.getSpawner(EntityClassification.MONSTER);
        for (MobSpawnInfo.Spawners spawner : spawners) {
            if (spawner.field_242588_c == typeToAdd && spawner.field_76292_a > 0) {
                return;
            }
            if (spawner.field_242588_c != typeToCopy || spawner.field_76292_a <= 0) continue;
            spawnersToCopy.add(spawner);
        }
        if (!spawnersToCopy.isEmpty()) {
            for (MobSpawnInfo.Spawners spawner : spawnersToCopy) {
                NaturalSpawnManager.addSpawn(builder, typeToAdd, Math.max(1, MathHelper.func_76128_c((double)((double)spawner.field_76292_a * multi))), spawner.field_242589_d, spawner.field_242590_e);
            }
            MobSpawnInfo.SpawnCosts costsToCopy = builder.getCost(typeToCopy);
            if (costsToCopy != null) {
                builder.func_242573_a(typeToAdd, costsToCopy.func_242585_b(), costsToCopy.func_242582_a());
            }
        }
    }

    private static void addBiomeCategorySpawns(MobSpawnInfoBuilder builder, Biome.Category category, @Nullable ResourceLocation name) {
        switch (category) {
            case OCEAN: {
                NaturalSpawnManager.addSpawn(builder, (EntityType)DrowningCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.drowningCreeperOceanWeight.get());
                NaturalSpawnManager.addSpawn(builder, (EntityType)BlueberrySlimeEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.blueberrySlimeOceanWeight.get());
                break;
            }
            case RIVER: {
                NaturalSpawnManager.addSpawn(builder, (EntityType)DrowningCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.drowningCreeperRiverWeight.get());
                NaturalSpawnManager.addSpawn(builder, (EntityType)BlueberrySlimeEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.blueberrySlimeRiverWeight.get());
                break;
            }
            case NETHER: {
                NaturalSpawnManager.addNetherSpawns(builder, name);
            }
        }
    }

    private static void addNetherSpawns(MobSpawnInfoBuilder builder, @Nullable ResourceLocation name) {
        if (NaturalSpawnManager.isBiome(name, (RegistryKey<Biome>)Biomes.field_235250_aA_)) {
            return;
        }
        if (NaturalSpawnManager.isBiome(name, (RegistryKey<Biome>)Biomes.field_235252_ay_)) {
            NaturalSpawnManager.addSpawn(builder, EntityType.field_200722_aA, Config.MAIN.NATURAL_SPAWNING.witherSkeletonSoulSandValleyWeight.get(), 5, 5, 0.7, 0.15);
            return;
        }
        NaturalSpawnManager.addSpawn(builder, EntityType.field_200722_aA, Config.MAIN.NATURAL_SPAWNING.witherSkeletonNetherWeight.get(), 5, 5);
        if (NaturalSpawnManager.isBiome(name, (RegistryKey<Biome>)Biomes.field_235251_aB_)) {
            NaturalSpawnManager.addSpawn(builder, EntityType.field_200792_f, Config.MAIN.NATURAL_SPAWNING.blazeBasaltDeltasWeight.get(), 2, 3);
        } else {
            NaturalSpawnManager.addSpawn(builder, EntityType.field_200792_f, Config.MAIN.NATURAL_SPAWNING.blazeNetherWeight.get(), 2, 3);
        }
        NaturalSpawnManager.addSpawn(builder, (EntityType)FireCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.fireCreeperNetherWeight.get(), 4, 4);
        NaturalSpawnManager.addSpawn(builder, (EntityType)FireZombieEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.fireZombieNetherWeight.get(), 4, 4);
        NaturalSpawnManager.addSpawn(builder, (EntityType)FireSpiderEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.fireSpiderNetherWeight.get(), 4, 4);
    }

    private static boolean isBiome(@Nullable ResourceLocation name, RegistryKey<Biome> biome) {
        return biome.func_240901_a_().equals((Object)name);
    }

    private static void addSpawn(MobSpawnInfoBuilder builder, EntityType<?> entity, int weight) {
        NaturalSpawnManager.addSpawn(builder, entity, weight, 1, 1);
    }

    private static void addSpawn(MobSpawnInfoBuilder builder, EntityType<?> entity, int weight, int minCount, int maxCount) {
        if (weight > 0) {
            builder.func_242575_a(entity.func_220339_d(), new MobSpawnInfo.Spawners(entity, weight, minCount, maxCount));
        }
    }

    private static void addSpawn(MobSpawnInfoBuilder builder, EntityType<?> entity, int weight, int minCount, int maxCount, double charge, double budget) {
        if (weight > 0) {
            builder.func_242575_a(entity.func_220339_d(), new MobSpawnInfo.Spawners(entity, weight, minCount, maxCount));
            builder.func_242573_a(entity, charge, budget);
        }
    }
}

