/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.event;

import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class AdvancementFixer {
    private static final ResourceLocation KILL_A_MOB_ADV = new ResourceLocation("adventure/kill_a_mob");
    private static final ResourceLocation KILL_ALL_MOBS_ADV = new ResourceLocation("adventure/kill_all_mobs");
    private static final ResourceLocation SNIPER_DUEL_ADV = new ResourceLocation("adventure/sniper_duel");
    private static final ResourceLocation RETURN_TO_SENDER_ADV = new ResourceLocation("nether/return_to_sender");
    private static final ResourceLocation UNEASY_ALLIANCE_ADV = new ResourceLocation("nether/uneasy_alliance");
    private AdvancementManager manager;

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        this.manager = event.getServer().func_191949_aK();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (!livingEntity.field_70170_p.field_72995_K && source.func_76346_g() instanceof ServerPlayerEntity && livingEntity instanceof ISpecialMob) {
            Advancement uneasyAlliance;
            Advancement returnToSender;
            Advancement sniperDuel;
            Advancement killAllMob;
            Advancement killAMob;
            ServerPlayerEntity player = (ServerPlayerEntity)source.func_76346_g();
            if (this.notCompleted(player, killAMob = this.getFromId(KILL_A_MOB_ADV))) {
                this.maybeGrantKillAMob((LivingEntity)((ISpecialMob)livingEntity), player, source, killAMob);
            }
            if (this.notCompleted(player, killAllMob = this.getFromId(KILL_ALL_MOBS_ADV))) {
                this.maybeGrantKillAllMobs((LivingEntity)((ISpecialMob)livingEntity), player, source, killAllMob);
            }
            if (this.notCompleted(player, sniperDuel = this.getFromId(SNIPER_DUEL_ADV))) {
                this.maybeGrantSniperDuel((LivingEntity)((ISpecialMob)livingEntity), player, source, sniperDuel);
            }
            if (this.notCompleted(player, returnToSender = this.getFromId(RETURN_TO_SENDER_ADV))) {
                this.maybeGrantReturnToSender((LivingEntity)((ISpecialMob)livingEntity), player, source, returnToSender);
            }
            if (this.notCompleted(player, uneasyAlliance = this.getFromId(UNEASY_ALLIANCE_ADV))) {
                AdvancementFixer.maybeGrantUneasyAlliance((LivingEntity)((ISpecialMob)livingEntity), player, source, uneasyAlliance);
            }
        }
    }

    private <T extends LivingEntity> void maybeGrantKillAMob(T dead, ServerPlayerEntity player, DamageSource damageSource, Advancement advancement) {
        if (damageSource.func_76346_g() instanceof PlayerEntity && !dead.field_70170_p.field_72995_K) {
            player.func_192039_O().func_192750_a(advancement, "minecraft:creeper");
        }
    }

    private <T extends LivingEntity> void maybeGrantKillAllMobs(T dead, ServerPlayerEntity player, DamageSource damageSource, Advancement advancement) {
        if (damageSource.func_76346_g() instanceof PlayerEntity && !dead.field_70170_p.field_72995_K) {
            for (EntityType<?> type : ((ISpecialMob)dead).getSpecies().family.replaceableTypes) {
                player.func_192039_O().func_192750_a(advancement, Objects.requireNonNull(type.getRegistryName()).toString());
            }
        }
    }

    private <T extends LivingEntity> void maybeGrantSniperDuel(T dead, ServerPlayerEntity player, DamageSource damageSource, Advancement advancement) {
        float z;
        float x;
        float dist;
        if (dead instanceof _SpecialSkeletonEntity && damageSource.func_76364_f() instanceof ProjectileEntity && (dist = MathHelper.func_76129_c((float)((x = (float)(dead.func_226277_ct_() - player.func_226277_ct_())) * x + (z = (float)(dead.func_226281_cx_() - player.func_226281_cx_())) * z))) >= 50.0f) {
            player.func_192039_O().func_192750_a(advancement, "killed_skeleton");
        }
    }

    private <T extends LivingEntity> void maybeGrantReturnToSender(T dead, ServerPlayerEntity player, DamageSource damageSource, Advancement advancement) {
        if (dead instanceof _SpecialGhastEntity && damageSource.func_76364_f() instanceof AbstractFireballEntity) {
            player.func_192039_O().func_192750_a(advancement, "killed_ghast");
        }
    }

    private static <T extends LivingEntity> void maybeGrantUneasyAlliance(T dead, ServerPlayerEntity player, DamageSource damageSource, Advancement advancement) {
        if (dead instanceof _SpecialGhastEntity && dead.field_70170_p.func_234923_W_().equals(World.field_234918_g_)) {
            player.func_192039_O().func_192750_a(advancement, "killed_ghast");
        }
    }

    private boolean notCompleted(ServerPlayerEntity player, @Nullable Advancement advancement) {
        if (advancement == null) {
            return false;
        }
        return !player.func_192039_O().func_192747_a(advancement).func_192105_a();
    }

    @Nullable
    private Advancement getFromId(ResourceLocation advancementId) {
        return this.manager.func_192778_a(advancementId);
    }
}

